/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.idmap;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.projection.technique.idmap.IDMAPProjectionParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Interactive Document Map (IDMAP)", description="Project points from a multidimensional space to the plane preserving the distance relations.", howtocite="Minghim, R.; Paulovich, F. V.; Lopes, A. A. Content-based text mapping using multidimensional projections for exploration of document collections. IS&T/SPIE Symposium on Electronic Imaging - Visualization and Data Analysis, San Jose, CA, USA, Jan., 2006.")
public class IDMAPProjectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private IDMAPProjection.InitializationType ini = IDMAPProjection.InitializationType.FASTMAP;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private int nriterations = 50;
    private float fracdelta = 8.0f;
    private transient IDMAPProjectionParamView paramview;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        IDMAPProjection idmap = new IDMAPProjection();
        idmap.setFractionDelta(this.fracdelta);
        idmap.setInitialization(this.ini);
        idmap.setNumberIterations(this.nriterations);
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.projection = idmap.project(this.matrix, diss);
        } else if (this.dmat != null) {
            this.projection = idmap.project(this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new IDMAPProjectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
        this.dmat = null;
    }

    public IDMAPProjection.InitializationType getInitialization() {
        return this.ini;
    }

    public void setInitialization(IDMAPProjection.InitializationType ini) {
        this.ini = ini;
    }

    public int getNumberIterations() {
        return this.nriterations;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    public float getFractionDelta() {
        return this.fracdelta;
    }

    public void setFractionDelta(float fracdelta) {
        this.fracdelta = fracdelta;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }
}

