/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.idmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.projection.technique.idmap.IDMAPProjectionComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class IDMAPProjectionParamView
extends AbstractParametersView {
    private IDMAPProjectionComp comp;
    private JLabel deltaLabel;
    private JTextField deltaTextField;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JRadioButton fastmapRadioButton;
    private JPanel improvementPanel;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JRadioButton nnpRadioButton;
    private JPanel projectionPanel;
    private ButtonGroup projectorButtonGroup;

    public IDMAPProjectionParamView(IDMAPProjectionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.projectorButtonGroup = new ButtonGroup();
        this.improvementPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.deltaLabel = new JLabel();
        this.deltaTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.projectionPanel = new JPanel();
        this.nnpRadioButton = new JRadioButton();
        this.fastmapRadioButton = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder("IDMAP Parameters"));
        this.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Projection Improvement (Force)"));
        this.improvementPanel.setLayout(new GridBagLayout());
        this.nIterationsLabel.setText("Number of iterations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.deltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaLabel, gridBagConstraints);
        this.deltaTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.improvementPanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.projectionPanel.setBorder(BorderFactory.createTitledBorder("Type of Projection"));
        this.projectionPanel.setLayout(new GridBagLayout());
        this.projectorButtonGroup.add(this.nnpRadioButton);
        this.nnpRadioButton.setText("Nearest Neighbor Projection");
        this.nnpRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nnpRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.nnpRadioButton, gridBagConstraints);
        this.projectorButtonGroup.add(this.fastmapRadioButton);
        this.fastmapRadioButton.setText("Fastmap Projection");
        this.fastmapRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fastmapRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.fastmapRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.projectionPanel, gridBagConstraints);
    }

    public void reset() {
        this.deltaTextField.setText(Float.toString(this.comp.getFractionDelta()));
        this.nIterationsTextField.setText(Integer.toString(this.comp.getNumberIterations()));
        if (this.comp.getInitialization().equals((Object)IDMAPProjection.InitializationType.FASTMAP)) {
            this.fastmapRadioButton.setSelected(true);
            this.nnpRadioButton.setSelected(false);
        } else if (this.comp.getInitialization().equals((Object)IDMAPProjection.InitializationType.NNP)) {
            this.fastmapRadioButton.setSelected(false);
            this.nnpRadioButton.setSelected(true);
        }
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        int nit;
        float delta;
        if (this.deltaTextField.getText().trim().length() > 0) {
            delta = Float.parseFloat(this.deltaTextField.getText());
            if (!(delta > 0.0f)) {
                throw new IOException("The fraction of delta should be positive.");
            }
        } else {
            throw new IOException("The fraction of delta should be provided.");
        }
        this.comp.setFractionDelta(delta);
        if (this.nIterationsTextField.getText().trim().length() > 0) {
            nit = Integer.parseInt(this.nIterationsTextField.getText());
            if (nit <= -1) {
                throw new IOException("The number of iterations should be positive.");
            }
        } else {
            throw new IOException("The number of iterations should be provided.");
        }
        this.comp.setNumberIterations(nit);
        if (this.fastmapRadioButton.isSelected()) {
            this.comp.setInitialization(IDMAPProjection.InitializationType.FASTMAP);
        } else if (this.nnpRadioButton.isSelected()) {
            this.comp.setInitialization(IDMAPProjection.InitializationType.NNP);
        } else {
            throw new IOException("A projector must be selected.");
        }
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

