/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.isomap;

import simpletree.datamining.neighbors.Pair;

public class Dijkstra {
    private Graph graph;

    public Dijkstra(Pair[][] neighborhood) {
        this.graph = new Graph(neighborhood);
    }

    public float[] execute(int source) {
        if (source < this.graph.getNodes().length) {
            int i;
            Node[] nodes = this.graph.getNodes();
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2].d = Float.POSITIVE_INFINITY;
            }
            nodes[source].d = 0.0f;
            Heap heap = new Heap(this.graph.getNodes());
            while (!heap.empty()) {
                Node u = heap.remove();
                for (i = 0; i < u.edges.length; ++i) {
                    Node v = nodes[u.edges[i].index];
                    float w = u.d + u.edges[i].value;
                    if (!(v.d > w)) continue;
                    heap.decreaseKey(v, w);
                }
            }
            float[] s = new float[this.graph.getNodes().length];
            for (i = 0; i < nodes.length; ++i) {
                s[i] = nodes[i].d;
            }
            return s;
        }
        return null;
    }

    class Node {
        public int id;
        public int heapindex;
        public float d;
        public Pair[] edges;

        public Node(int id, Pair[] edges) {
            this.edges = edges;
            this.id = id;
            this.d = Float.POSITIVE_INFINITY;
            this.heapindex = -1;
        }
    }

    class Heap {
        private Node[] nodes;
        private int end;

        public Heap(Node[] nodes) {
            this.nodes = new Node[nodes.length];
            this.end = -1;
            for (int i = 0; i < nodes.length; ++i) {
                this.insert(nodes[i]);
            }
        }

        public boolean empty() {
            return this.end == -1;
        }

        public boolean full() {
            return this.end == this.nodes.length - 1;
        }

        public boolean insert(Node node) {
            if (!this.full()) {
                ++this.end;
                this.nodes[this.end] = node;
                this.nodes[this.end].heapindex = this.end;
                this.bubblingUp(this.end);
                return true;
            }
            return false;
        }

        public Node remove() {
            if (!this.empty()) {
                Node node = this.nodes[0];
                this.nodes[0] = this.nodes[this.end];
                this.nodes[0].heapindex = 0;
                --this.end;
                this.bubblingDown(0);
                return node;
            }
            return null;
        }

        public void increaseKey(Node node, float newd) {
            if (newd > node.d) {
                node.d = newd;
                this.bubblingDown(node.heapindex);
            }
        }

        public void decreaseKey(Node node, float newd) {
            if (newd < node.d) {
                node.d = newd;
                this.bubblingUp(node.heapindex);
            }
        }

        private void bubblingUp(int index) {
            int parent = (index - 1) / 2;
            while (index > 0 && this.nodes[index].d <= this.nodes[parent].d) {
                Node tmp = this.nodes[index];
                this.nodes[index] = this.nodes[parent];
                this.nodes[index].heapindex = index;
                this.nodes[parent] = tmp;
                this.nodes[parent].heapindex = parent;
                index = parent;
                parent = (parent - 1) / 2;
            }
        }

        private void bubblingDown(int index) {
            while (index < this.end / 2) {
                int leftchild = 2 * index + 1;
                int rightchild = 2 * index + 2;
                int largestchild = leftchild < this.end && this.nodes[leftchild].d > this.nodes[rightchild].d ? rightchild : leftchild;
                if (this.nodes[index].d <= this.nodes[largestchild].d) break;
                Node tmp = this.nodes[index];
                this.nodes[index] = this.nodes[largestchild];
                this.nodes[index].heapindex = index;
                this.nodes[largestchild] = tmp;
                this.nodes[largestchild].heapindex = largestchild;
                index = largestchild;
            }
        }
    }

    class Graph {
        private Node[] nodes;

        public Graph(Pair[][] neighborhood) {
            this.complete(neighborhood);
            this.nodes = new Node[neighborhood.length];
            for (int i = 0; i < neighborhood.length; ++i) {
                this.nodes[i] = new Node(i, neighborhood[i]);
            }
        }

        private void complete(Pair[][] neighbors) {
            for (int i = 0; i < neighbors.length; ++i) {
                for (int j = 0; j < neighbors[i].length; ++j) {
                    boolean contain = false;
                    for (int k = 0; k < neighbors[neighbors[i][j].index].length; ++k) {
                        if (neighbors[neighbors[i][j].index][k].index != i) continue;
                        contain = true;
                        break;
                    }
                    if (contain) continue;
                    Pair[] newneighbors = new Pair[neighbors[neighbors[i][j].index].length + 1];
                    for (int k = 0; k < newneighbors.length - 1; ++k) {
                        newneighbors[k] = neighbors[neighbors[i][j].index][k];
                    }
                    newneighbors[newneighbors.length - 1] = new Pair(i, neighbors[i][j].value);
                    neighbors[neighbors[i][j].index] = newneighbors;
                }
            }
        }

        public Node getNode(int index) {
            return this.nodes[index];
        }

        public Node[] getNodes() {
            return this.nodes;
        }
    }
}

