/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.isomap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.technique.isomap.ISOMAPProjectionComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class ISOMAPProjectionParamView
extends AbstractParametersView {
    private ISOMAPProjectionComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JLabel nrNeighborsLabel;
    private JTextField nrNeighborsTextField;
    private JPanel parametersPanel;

    public ISOMAPProjectionParamView(ISOMAPProjectionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.parametersPanel = new JPanel();
        this.nrNeighborsLabel = new JLabel();
        this.nrNeighborsTextField = new JTextField();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("ISOMAP Parameters"));
        this.setLayout(new GridBagLayout());
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.nrNeighborsLabel.setText("Number of Neighbors");
        this.parametersPanel.add(this.nrNeighborsLabel);
        this.nrNeighborsTextField.setColumns(10);
        this.parametersPanel.add(this.nrNeighborsTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add(this.parametersPanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
    }

    public void reset() {
        this.nrNeighborsTextField.setText(Integer.toString(this.comp.getNumberNeighbors()));
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        int nneighbors;
        if (this.nrNeighborsTextField.getText().trim().length() > 0) {
            nneighbors = Integer.parseInt(this.nrNeighborsTextField.getText());
            if (nneighbors <= 0) {
                throw new IOException("The number of neighbors should be positive.");
            }
        } else {
            throw new IOException("The number of neighbors should be provided.");
        }
        this.comp.setNumberNeighbors(nneighbors);
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

