/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.lsp;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.technique.lsp.LSPProjection2D;
import simpletree.projection.technique.lsp.LSPProjection2DParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Least Square Projection (LSP)", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.", howtocite="Paulovich, F. V.; Nonato, L. G.; Minghim, R.; Levkowitz, H. Least Square Projection: a fast high precision multidimensional projection technique and its application to document mapping. IEEE Transactions on Visualization and Computer Graphics, v. 14, p. 564-575, 2008. ")
public class LSPProjection2DComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private int nriterations = 50;
    private float fracdelta = 8.0f;
    private int nrneighbors = 10;
    private int nrcontrolpoints = 10;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient LSPProjection2DParamView paramview;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    private transient ArrayList<Integer> controlpoints;
    private transient AbstractMatrix cpprojection;

    public void execute() throws IOException {
        LSPProjection2D lsp = new LSPProjection2D();
        lsp.setFractionDelta(this.fracdelta);
        lsp.setNumberIterations(this.nriterations);
        lsp.setNumberNeighbors(this.nrneighbors);
        lsp.setNumberControlPoints(this.nrcontrolpoints);
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            lsp.setControlPointsChoice(LSPProjection2D.ControlPointsType.KMEANS);
            if (this.controlpoints != null && this.cpprojection != null) {
                lsp.setControlPoints(this.controlpoints);
                lsp.setControlPointsProjection(this.cpprojection);
            }
            this.projection = lsp.project(this.matrix, diss);
        } else if (this.dmat != null) {
            lsp.setControlPointsChoice(LSPProjection2D.ControlPointsType.KMEDOIDS);
            this.projection = lsp.project(this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix, @Param(name="control points") ArrayList<Integer> controlpoints, @Param(name="control points projection") AbstractMatrix cpprojection) {
        this.matrix = matrix;
        this.controlpoints = controlpoints;
        this.cpprojection = cpprojection;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new LSPProjection2DParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
        this.dmat = null;
    }

    public int getNumberIterations() {
        return this.nriterations;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    public float getFractionDelta() {
        return this.fracdelta;
    }

    public void setFractionDelta(float fracdelta) {
        this.fracdelta = fracdelta;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public int getNumberControlPoints() {
        return this.nrcontrolpoints;
    }

    public void setNumberControlPoints(int nrcontrolpoints) {
        this.nrcontrolpoints = nrcontrolpoints;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }

    public int getNumberInstances() {
        if (this.matrix != null) {
            return this.matrix.getRowCount();
        }
        if (this.dmat != null) {
            return this.dmat.getElementCount();
        }
        return 0;
    }
}

