/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.lsp;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.isomap.ISOMAPProjection;
import simpletree.projection.technique.lsp.LSPProjection2D;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class LSPProjection2DISOMAP
extends LSPProjection2D {
    @Override
    protected AbstractMatrix projectControlPoints(DistanceMatrix dmat_cp) throws IOException {
        ISOMAPProjection isomap = new ISOMAPProjection();
        isomap.setNumberNeighbors(8);
        return isomap.project(dmat_cp);
    }

    public static void main(String[] args) throws IOException {
        String filename = "/home/paulovich/Dropbox/dados/swissroll10000.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(filename);
        ProjectionUtil.log(false, false);
        long start = System.currentTimeMillis();
        LSPProjection2DISOMAP lsp = new LSPProjection2DISOMAP();
        lsp.setNumberNeighbors(8);
        lsp.setControlPointsChoice(LSPProjection2D.ControlPointsType.RANDOM);
        lsp.setFractionDelta(8.0f);
        lsp.setNumberIterations(50);
        lsp.setNumberControlPoints(matrix.getRowCount() / 10);
        AbstractMatrix projection = lsp.project(matrix, new Euclidean());
        long finish = System.currentTimeMillis();
        System.out.println("LSP time: " + (float)(finish - start) / 1000.0f + "s");
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.setTitle("LSP");
        frame.execute();
    }
}

