/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.mds;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.technique.mds.ClassicalMDSProjection;
import simpletree.projection.technique.mds.ClassicalMDSProjectionParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Classical Multidimensional Scaling (MDS)", description="Project points from a multidimensional space to the plane preserving the distance relations.", howtocite="Cox, T. F.; Cox, M. A. A. Multidimensional scaling. Second ed. Chapman & Hall/CRC,2000.")
public class ClassicalMDSProjectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient ClassicalMDSProjectionParamView paramview;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        ClassicalMDSProjection mds = new ClassicalMDSProjection();
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.projection = mds.project(this.matrix, diss);
        } else if (this.dmat != null) {
            this.projection = mds.project(this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new ClassicalMDSProjectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }
}

