/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud;

import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import simpletree.datamining.clustering.BKmeans;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.projection.ProjectionPolygonModel;
import simpletree.projectioncloud.projection.Projector;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.Stopword;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.MatrixTransformationFactory;

public class NaiveTest {
    public static void main(String[] args) throws IOException {
        String stpfilename = "D:\\stopwords_eng.spw";
        String corpusfilename = "D:\\AP_BBC_CNN_Reuters_nosource_nodate_novo.zip";
        int lowercut = 10;
        int uppercut = -1;
        int nrclusters = 6;
        Stopword stp = Stopword.getInstance();
        stp.changeStopwordList(stpfilename);
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        MatrixTransformation mt = MatrixTransformationFactory.getInstance(MatrixTransformationFactory.MatrixTransformationType.TF_IDF);
        AbstractMatrix matrixtfidf = mt.tranform(matrixtf, null);
        Projector p = new Projector();
        AbstractMatrix proj = p.execute(matrixtfidf);
        ProjectionPolygonModel model = new ProjectionPolygonModel();
        Scalar cdata = model.addScalar("cdata");
        Scalar dots = model.addScalar("...");
        int nrows = proj.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            AbstractVector row = proj.getRow(i);
            ProjectionInstance pi = new ProjectionInstance(row.getId(), row.getValue(0), row.getValue(1));
            model.addInstance(pi);
            pi.setScalarValue(cdata, row.getKlass());
            pi.setScalarValue(dots, 0.0f);
        }
        BKmeans kmeans = new BKmeans(nrclusters);
        ArrayList<ArrayList<Integer>> clusters = kmeans.execute(new Euclidean(), proj);
        long initTime = System.currentTimeMillis();
        System.out.println("Start building word cloud...");
        ArrayList<Integer> cluster = clusters.get(0);
        Group group = new Group(cluster);
        group.calculateTerms(matrixtfidf);
        int[] pointsx = new int[]{0, 150, 150};
        int[] pointsy = new int[]{0, 150, 0};
        Polygon pol = new Polygon(pointsx, pointsy, 3);
        group.setPolygon(pol);
        group.fillPolygon();
        System.out.println("Total time: " + (float)(System.currentTimeMillis() - initTime) / 1000.0f);
        BufferedImage im = new BufferedImage(400, 400, 2);
        group.draw(im, true);
        ImageIO.write((RenderedImage)im, "png", new File("D:\\testeCloud.png"));
    }
}

