/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.fill;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import simpletree.projectioncloud.fill.TermRectangle;

public class PolygonCoverage {
    private int deltax = 5;
    private int deltay = 5;
    private Cell[][] grid;
    private Polygon pol;
    private Polygon origpol;
    private Point centr;

    public final void execute(Polygon pol, ArrayList<TermRectangle> rectangles) {
        this.pol = pol;
        this.origpol = new Polygon();
        for (int i = 0; i < pol.npoints; ++i) {
            this.origpol.addPoint(pol.xpoints[i], pol.ypoints[i]);
        }
        this.sort(rectangles);
        this.centr = this.centroid(pol);
        this.grid();
        ArrayList<TermRectangle> aux = new ArrayList<TermRectangle>();
        for (int i = 0; i < rectangles.size(); ++i) {
            if (!rectangles.get(i).isFeasible()) continue;
            aux.add(rectangles.get(i));
        }
        long start = System.currentTimeMillis();
        while (!aux.isEmpty()) {
            TermRectangle r = (TermRectangle)aux.remove(0);
            Cell place = this.place(r);
            if (place != null) {
                r.x = place.pos.x;
                r.y = place.pos.y;
                this.occupy(r, place);
                continue;
            }
            r.rotate();
            place = this.place(r);
            if (place != null) {
                r.x = place.pos.x;
                r.y = place.pos.y;
                this.occupy(r, place);
                continue;
            }
            float scale = 0.95f;
            this.grid();
            aux = new ArrayList();
            for (int i = 0; i < rectangles.size(); ++i) {
                if (!rectangles.get(i).isFeasible()) continue;
                aux.add(rectangles.get(i));
            }
            for (TermRectangle rect : aux) {
                rect.scale(scale);
                if (rect.direction != TermRectangle.Direction.VERTICAL) continue;
                rect.rotate();
            }
        }
        long end = System.currentTimeMillis();
    }

    private void sort(ArrayList<TermRectangle> rectangles) {
        Collections.sort(rectangles, new Comparator<TermRectangle>(){

            @Override
            public int compare(TermRectangle o1, TermRectangle o2) {
                return o2.width * o2.height - o1.width * o1.height;
            }
        });
    }

    private Cell place(TermRectangle r) {
        Cell cp = null;
        float dist = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                float dst;
                if (!this.canOccupy(r, this.grid[i][j]) || !(dist > (dst = this.distance(this.centr, new Point(this.grid[i][j].pos.x + r.width / 2, this.grid[i][j].pos.y + r.height / 2))))) continue;
                cp = this.grid[i][j];
                dist = dst;
            }
        }
        return cp;
    }

    private void occupy(TermRectangle r, Cell c) {
        int sizex = r.width / this.deltax + (r.width % this.deltax > 0 ? 1 : 0);
        int sizey = r.height / this.deltay + (r.height % this.deltay > 0 ? 1 : 0);
        for (int i = 0; i < sizey; ++i) {
            for (int j = 0; j < sizex; ++j) {
                this.grid[i + c.lin][j + c.col].filled = true;
            }
        }
    }

    private boolean canOccupy(TermRectangle r, Cell c) {
        if (c.filled) {
            return false;
        }
        int sizex = r.width / this.deltax + (r.width % this.deltax > 0 ? 1 : 0);
        int sizey = r.height / this.deltay + (r.height % this.deltay > 0 ? 1 : 0);
        if (sizey + c.lin > this.grid.length || sizex + c.col > this.grid[0].length) {
            return false;
        }
        for (int i = 0; i < sizey; ++i) {
            for (int j = 0; j < sizex; ++j) {
                if (!this.grid[i + c.lin][j + c.col].filled) continue;
                return false;
            }
        }
        return true;
    }

    private float distance(Point a, Point b) {
        return (float)Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
    }

    private Point centroid(Polygon pol) {
        Point centraux = new Point(0, 0);
        for (int i = 0; i < pol.npoints; ++i) {
            centraux.x += pol.xpoints[i];
            centraux.y += pol.ypoints[i];
        }
        centraux.x /= pol.npoints;
        centraux.y /= pol.npoints;
        return centraux;
    }

    private void grid() {
        Rectangle bounds = this.pol.getBounds();
        int sizex = bounds.width / this.deltax;
        int sizey = bounds.height / this.deltay;
        this.grid = new Cell[sizey][sizex];
        for (int i = 0; i < sizey; ++i) {
            for (int j = 0; j < sizex; ++j) {
                this.grid[i][j] = new Cell();
                this.grid[i][j].pos.setLocation(bounds.x + j * this.deltax, bounds.y + i * this.deltay);
                this.grid[i][j].filled = this.pol.contains(this.grid[i][j].pos.x, this.grid[i][j].pos.y);
                this.grid[i][j].filled &= this.pol.contains(this.grid[i][j].pos.x + this.deltax - 1, this.grid[i][j].pos.y);
                this.grid[i][j].filled &= this.pol.contains(this.grid[i][j].pos.x + this.deltax - 1, this.grid[i][j].pos.y + this.deltay - 1);
                this.grid[i][j].filled &= this.pol.contains(this.grid[i][j].pos.x, this.grid[i][j].pos.y + this.deltay - 1);
                this.grid[i][j].filled = !this.grid[i][j].filled;
                this.grid[i][j].lin = i;
                this.grid[i][j].col = j;
            }
        }
    }

    public static void main(String[] args) {
        Polygon pol = new Polygon();
        pol.addPoint(20, 20);
        pol.addPoint(200, 20);
        pol.addPoint(250, 50);
        pol.addPoint(200, 150);
        pol.addPoint(20, 150);
        PolygonCoverage cov = new PolygonCoverage();
        cov.pol = pol;
        cov.grid();
        System.out.println("End!");
    }

    public class Cell {
        public Point pos = new Point();
        public int lin = 0;
        public int col = 0;
        public boolean filled = false;
    }
}

