/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.projection;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import simpletree.projectioncloud.fill.Group;

public class ProjectionPolygonModel
extends ProjectionModel {
    private ArrayList<Group> groups;

    public void createTopics(AbstractMatrix matrix) throws IOException {
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).calculateTerms(matrix);
            }
        }
    }

    public void setClusters(ArrayList<ArrayList<Integer>> clusters) {
        this.groups = new ArrayList();
        for (int i = 0; i < clusters.size(); ++i) {
            this.groups.add(new Group(clusters.get(i)));
        }
        Scalar clusterScalar = this.addScalar("Clusters " + clusters.size());
        HashMap<Integer, Integer> cindex = new HashMap<Integer, Integer>();
        for (int i = 0; i < clusters.size(); ++i) {
            for (int j = 0; j < clusters.get(i).size(); ++j) {
                cindex.put(((AbstractInstance)this.instances.get(clusters.get(i).get(j))).getId(), i);
            }
        }
        for (AbstractInstance ai : this.getInstances()) {
            ProjectionInstance pi = (ProjectionInstance)ai;
            pi.setScalarValue(clusterScalar, ((Integer)cindex.get(pi.getId())).intValue());
        }
    }

    public void createPolygons() {
        long start = System.currentTimeMillis();
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).calculateConvexHullPolygon(this.instances);
                this.groups.get(i).fillPolygon();
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("total time: " + (float)(end - start) / 1000.0f);
    }

    public void setViewport(Rectangle visualizationArea) {
        float maxX = Float.NEGATIVE_INFINITY;
        float minX = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX < pi.getX()) {
                maxX = pi.getX();
            }
            if (minX > pi.getX()) {
                minX = pi.getX();
            }
            if (maxY < pi.getY()) {
                maxY = pi.getY();
            }
            if (!(minY > pi.getY())) continue;
            minY = pi.getY();
        }
        float beginX = visualizationArea.x;
        float endX = visualizationArea.x + visualizationArea.width;
        float beginY = visualizationArea.y;
        float endY = visualizationArea.y + visualizationArea.height;
        for (AbstractInstance instance : this.instances) {
            ProjectionInstance pi = (ProjectionInstance)instance;
            if (maxX != minX) {
                pi.setX((pi.getX() - minX) / (maxX - minX) * (endX - beginX) + beginX);
            } else {
                pi.setX(beginX);
            }
            if (maxY != minY) {
                pi.setY((pi.getY() - minY) / (maxY - minY) * (endY - beginY) + beginY);
                continue;
            }
            pi.setY(beginY);
        }
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            ProjectionInstance pi;
            int i;
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (!pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            if (this.groups != null) {
                for (i = 0; i < this.groups.size(); ++i) {
                    this.groups.get(i).draw(image, highquality);
                }
            }
        }
    }
}

