/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.projection;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.projectioncloud.fill.Group;

public class ProjectionSquareModel
extends ProjectionModel {
    private ArrayList<Group> groups;

    public void createTopics(AbstractMatrix matrix) throws IOException {
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).calculateTerms(matrix);
            }
        }
    }

    public void getClusters(ArrayList<ArrayList<Integer>> clusters) {
    }

    public void setClusters(ArrayList<ArrayList<Integer>> clusters) {
        this.groups = new ArrayList();
        for (int i = 0; i < clusters.size(); ++i) {
            this.groups.add(new Group(clusters.get(i)));
        }
        this.createPolygons();
    }

    private void createPolygons() {
        long start = System.currentTimeMillis();
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).calculateConvexHullPolygon(this.instances);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("total time: " + (float)(end - start) / 1000.0f);
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            ProjectionInstance pi;
            int i;
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (!pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            if (this.groups != null) {
                for (i = 0; i < this.groups.size(); ++i) {
                    this.groups.get(i).draw(image, highquality);
                }
            }
        }
    }
}

