/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.projectioncloud.topic.GraphTopic;
import simpletree.projectioncloud.topic.Term;

public class FrequencyTopic {
    private AbstractMatrix matrix;

    public FrequencyTopic(AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public ArrayList<Term> create(ArrayList<Integer> cluster, int nrterms) throws IOException {
        AbstractMatrix auxmat = MatrixFactory.getInstance(this.matrix.getClass());
        for (int i = 0; i < cluster.size(); ++i) {
            auxmat.addRow(this.matrix.getRow(cluster.get(i)));
        }
        float[][] points = auxmat.toMatrix();
        int[] freq = new int[auxmat.getDimensions()];
        Arrays.fill(freq, 0);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                int n = j;
                freq[n] = (int)((float)freq[n] + points[i][j]);
            }
        }
        ArrayList<GraphTopic.Pair> seq = new ArrayList<GraphTopic.Pair>();
        for (int i = 0; i < freq.length; ++i) {
            seq.add(new GraphTopic.Pair(i, freq[i]));
        }
        Collections.sort(seq);
        ArrayList<String> attributes = this.matrix.getAttributes();
        ArrayList<Term> topic = new ArrayList<Term>();
        for (int i = 0; i < Math.min(nrterms, seq.size()); ++i) {
            if (!(((GraphTopic.Pair)seq.get((int)i)).freq >= ((GraphTopic.Pair)seq.get((int)0)).freq * 0.15f)) continue;
            Term t = new Term(attributes.get(((GraphTopic.Pair)seq.get((int)i)).index), ((GraphTopic.Pair)seq.get((int)i)).freq);
            topic.add(t);
        }
        for (Term t : topic) {
            System.out.print(t.term + "<>" + t.weight + ";");
        }
        System.out.println();
        return topic;
    }
}

