/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.horrabin.horrorss.RssItemBean;
import org.horrabin.horrorss.RssParser;

public class CreateRSSCorpus {
    public void execute(String filename, ArrayList<String> links) {
        ArrayList<RssItemBean> news = new ArrayList<RssItemBean>();
        for (int i = 0; i < links.size(); ++i) {
            RssParser rss = new RssParser(links.get(i).trim());
            rss.parse();
            news.addAll(rss.getItems());
        }
        System.out.println("Number news:" + news.size());
        this.save(filename, news);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename, ArrayList<RssItemBean> news) {
        if (news.size() > 0) {
            DeflaterOutputStream zout = null;
            try {
                FileOutputStream dest = new FileOutputStream(filename);
                zout = new ZipOutputStream(new BufferedOutputStream(dest));
                ((ZipOutputStream)zout).setMethod(8);
                for (int i = 0; i < news.size(); ++i) {
                    ZipEntry entry = new ZipEntry(i + ".txt");
                    ((ZipOutputStream)zout).putNextEntry(entry);
                    RssItemBean element = news.get(i);
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(element.getTitle()).append("\r\n");
                    buffer.append(element.getDescription().replaceAll("\\<.*?\\>", "")).append("\r\n");
                    String filecontent = buffer.toString();
                    ((ZipOutputStream)zout).write(filecontent.getBytes(), 0, filecontent.length());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CreateRSSCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (zout != null) {
                    try {
                        zout.flush();
                        ((ZipOutputStream)zout).finish();
                        ((ZipOutputStream)zout).close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CreateRSSCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> links = new ArrayList<String>();
        links.add("http://rss.cnn.com/rss/edition.rss");
        links.add("http://rss.cnn.com/rss/edition_world.rss");
        links.add("http://rss.cnn.com/rss/edition_africa.rss");
        links.add("http://rss.cnn.com/rss/edition_americas.rss");
        links.add("http://rss.cnn.com/rss/edition_asia.rss");
        links.add("http://rss.cnn.com/rss/edition_europe.rss");
        links.add("http://rss.cnn.com/rss/edition_meast.rss");
        links.add("http://rss.cnn.com/rss/edition_us.rss");
        links.add("http://rss.cnn.com/rss/edition_business.rss");
        links.add("http://rss.cnn.com/rss/edition_technology.rss");
        links.add("http://rss.cnn.com/rss/edition_space.rss");
        links.add("http://rss.cnn.com/rss/edition_entertainment.rss");
        links.add("http://rss.cnn.com/rss/edition_sport.rss");
        links.add("http://rss.cnn.com/rss/edition_football.rss");
        links.add("http://rss.cnn.com/rss/edition_golf.rss");
        links.add("http://rss.cnn.com/rss/edition_motorsport.rss");
        links.add("http://rss.cnn.com/rss/edition_tennis.rss");
        links.add("http://rss.cnn.com/rss/edition_travel.rss");
        links.add("http://rss.cnn.com/rss/cnn_freevideo.rss");
        links.add("http://rss.cnn.com/rss/cnn_latest.rss");
        links.add("http://rss.cnn.com/rss/edition_business360.rss");
        links.add("http://rss.cnn.com/rss/edition_connecttheworld.rss");
        links.add("http://rss.cnn.com/rss/edition_inthefield.rss");
        links.add("http://rss.cnn.com/rss/edition_ime.rss");
        links.add("http://rss.cnn.com/rss/edition_idesk.rss");
        links.add("http://rss.cnn.com/rss/edition_prismblog.rss");
        links.add("http://rss.cnn.com/rss/edition_questmeansbusiness.rss");
        links.add("http://rss.cnn.com/rss/edition_screeningroom.rss");
        links.add("http://rss.cnn.com/rss/edition_worldsportblog.rss");
        links.add("http://rss.cnn.com/rss/edition_ukelectionblog.rss");
        links.add("http://feeds.reuters.com/reuters/artNews");
        links.add("http://feeds.reuters.com/reuters/businessNews");
        links.add("http://feeds.reuters.com/ReutersBusinessTravel");
        links.add("http://feeds.reuters.com/reuters/companyNews");
        links.add("http://feeds.reuters.com/Counterparties");
        links.add("http://feeds.reuters.com/reuters/Election2012");
        links.add("http://feeds.reuters.com/reuters/entertainment");
        links.add("http://feeds.reuters.com/reuters/environment");
        links.add("http://feeds.reuters.com/reuters/healthNews");
        links.add("http://feeds.reuters.com/reuters/lifestyle");
        links.add("http://feeds.reuters.com/reuters/mediaNews");
        links.add("http://feeds.reuters.com/reuters/USpersonalfinanceNews");
        links.add("http://feeds.reuters.com/reuters/MostRead");
        links.add("http://feeds.reuters.com/reuters/oddlyEnoughNews");
        links.add("http://feeds.reuters.com/ReutersPictures");
        links.add("http://feeds.reuters.com/reuters/peopleNews");
        links.add("http://feeds.reuters.com/Reuters/PoliticsNews");
        links.add("http://feeds.reuters.com/reuters/scienceNews");
        links.add("http://feeds.reuters.com/reuters/sportsNews");
        links.add("http://feeds.reuters.com/reuters/technologyNews");
        links.add("http://feeds.reuters.com/reuters/topNews");
        links.add("http://feeds.reuters.com/Reuters/domesticNews");
        links.add("http://feeds.reuters.com/Reuters/worldNews");
        links.add("http://feeds.reuters.com/reuters/bankruptcyNews");
        links.add("http://feeds.reuters.com/reuters/bondsNews");
        links.add("http://feeds.reuters.com/reuters/dealsNews");
        links.add("http://feeds.reuters.com/reuters/GCAeconomicNews");
        links.add("http://feeds.reuters.com/reuters/financialServicesrealEstateNews");
        links.add("http://feeds.reuters.com/reuters/globalmarketsNews");
        links.add("http://feeds.reuters.com/reuters/hedgefundsNews");
        links.add("http://feeds.reuters.com/reuters/hotStocksNews");
        links.add("http://feeds.reuters.com/reuters/newIssuesNews");
        links.add("http://feeds.reuters.com/reuters/mergersNews");
        links.add("http://feeds.reuters.com/reuters/privateequityNews");
        links.add("http://feeds.reuters.com/reuters/governmentfilingsNews");
        links.add("http://feeds.reuters.com/reuters/smallBusinessNews");
        links.add("http://feeds.reuters.com/reuters/summitNews");
        links.add("http://feeds.reuters.com/reuters/USdollarreportNews");
        links.add("http://feeds.reuters.com/reuters/USmarketsNews");
        links.add("http://feeds.reuters.com/reuters/basicmaterialsNews");
        links.add("http://feeds.reuters.com/reuters/cyclicalconsumergoodsNews");
        links.add("http://feeds.reuters.com/reuters/USenergyNews");
        links.add("http://feeds.reuters.com/reuters/environment");
        links.add("http://feeds.reuters.com/reuters/financialsNews");
        links.add("http://feeds.reuters.com/reuters/UShealthcareNews");
        links.add("http://feeds.reuters.com/reuters/industrialsNews");
        links.add("http://feeds.reuters.com/reuters/USmediaDiversifiedNews");
        links.add("http://feeds.reuters.com/reuters/noncyclicalconsumergoodsNews");
        links.add("http://feeds.reuters.com/reuters/technologysectorNews");
        links.add("http://feeds.reuters.com/reuters/UStechnologyTelcomNews");
        links.add("http://feeds.reuters.com/reuters/telecomsectorNews");
        links.add("http://feeds.reuters.com/reuters/utilitiesNews");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/sportonline_world_edition/front_page/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/business/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/uk_politics/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/health/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/health/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/education/rss.xml");
        links.add("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/sci/tech/rss.xml");
        links.add("http://hosted.ap.org/lineups/SPTBASEBALL-rss_2.0.xml?SITE=NCMOR&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/TOPHEADS-rss_2.0.xml?SITE=NDBIS&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/USHEADS-rss_2.0.xml?SITE=AZMES&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/WORLDHEADS-rss_2.0.xml?SITE=ININS&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/POLITICSHEADS-rss_2.0.xml?SITE=NCMOR&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/BUSINESSHEADS-rss_2.0.xml?SITE=NCWIN&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/TECHHEADS-rss_2.0.xml?SITE=MAHYC&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/SPORTSHEADS-rss_2.0.xml?SITE=NYWHI&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/ENTERTAINMENT-rss_2.0.xml?SITE=PAYOK&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/HEALTHHEADS-rss_2.0.xml?SITE=NCCON&SECTION=HOME");
        links.add("http://hosted.ap.org/lineups/SCIENCEHEADS-rss_2.0.xml?SITE=NJHAC&SECTION=HOME");
        CreateRSSCorpus cr = new CreateRSSCorpus();
        cr.execute("D://corpus2.zip", links);
    }
}

