/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.util.ReadMap;

public class DrawMap
extends JFrame {
    public DrawMap() throws IOException {
        this.setSize(1200, 1000);
        this.setDefaultCloseOperation(3);
        Painel p = new Painel();
        p.execute();
        this.getContentPane().add(p);
    }

    public static void main(String[] args) throws IOException {
        DrawMap dm = new DrawMap();
        dm.setVisible(true);
    }

    public class Painel
    extends JPanel {
        private ArrayList<Polygon> pols = new ArrayList();
        private ArrayList<Group> groups;
        private BufferedImage image;

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }

        public final void execute() throws IOException {
            Polygon p;
            int i;
            ReadMap rm = new ReadMap();
            this.groups = rm.read("states_SEMALASKA.xml");
            float maxx = -2.1474836E9f;
            float maxy = -2.1474836E9f;
            float minx = 2.1474836E9f;
            float miny = 2.1474836E9f;
            for (i = 0; i < this.groups.size(); ++i) {
                p = this.groups.get(i).getPolygon();
                for (int j = 0; j < p.npoints; ++j) {
                    if (maxx < (float)p.xpoints[j]) {
                        maxx = p.xpoints[j];
                    }
                    if (minx > (float)p.xpoints[j]) {
                        minx = p.xpoints[j];
                    }
                    if (maxy < (float)p.ypoints[j]) {
                        maxy = p.ypoints[j];
                    }
                    if (!(miny > (float)p.ypoints[j])) continue;
                    miny = p.ypoints[j];
                }
            }
            for (i = 0; i < this.groups.size(); ++i) {
                p = this.groups.get(i).getPolygon();
                Polygon orig = new Polygon();
                for (int j = 0; j < p.npoints; ++j) {
                    p.xpoints[j] = (int)(((float)p.xpoints[j] - minx) / (maxx - minx) * 1090.0f + 10.0f);
                    p.ypoints[j] = (int)(((float)p.ypoints[j] - miny) / (maxy - miny) * 590.0f + 10.0f);
                    orig.addPoint(p.xpoints[j], p.ypoints[j]);
                }
                this.pols.add(orig);
                p.invalidate();
                this.groups.get(i).fillPolygon();
            }
            this.image = new BufferedImage(1200, 1000, 2);
            Graphics2D g2 = (Graphics2D)this.image.getGraphics();
            g2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            for (int i2 = 0; i2 < this.groups.size(); ++i2) {
                g2.setColor(Color.red);
                this.groups.get(i2).draw(this.image, true);
            }
        }
    }
}

