/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import com.jhlabs.map.proj.MercatorProjection;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.topic.Term;

public class ReadMap
extends DefaultHandler {
    private Group group;
    private ArrayList<Group> groups = new ArrayList();
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String COLOUR = "colour";
    private static final String POINT = "point";
    private static final String LONGITUDE = "lng";
    private static final String LATITUDE = "lat";

    public ArrayList<Group> read(String filename) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO-8859-1"));
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
            return this.groups;
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (qName.equalsIgnoreCase(STATE)) {
            String colour = attributes.getValue(COLOUR);
            String name = attributes.getValue(NAME);
            this.group = new Group(new ArrayList<Integer>());
            ArrayList<Term> terms = new ArrayList<Term>();
            Random rand = new Random(7L);
            for (int i = 0; i < 5; ++i) {
                int r = rand.nextInt(50);
                terms.add(new Term(name, r * r));
            }
            this.group.setTerms(terms);
            this.group.setPolygon(new Polygon());
            this.groups.add(this.group);
        } else if (qName.equalsIgnoreCase(POINT)) {
            String longitude = attributes.getValue(LONGITUDE);
            String latitude = attributes.getValue(LATITUDE);
            double lat = Math.toRadians(Double.parseDouble(latitude));
            double lng = Math.toRadians(Double.parseDouble(longitude));
            MercatorProjection proj = new MercatorProjection();
            Point2D.Double d = proj.project(lng, lat, new Point2D.Double());
            int magnifiedX = (int)Math.round((10.0 + d.x) * 6000.0);
            int magnifiedY = (int)Math.round((10.0 + d.y) * 6000.0);
            this.group.getPolygon().addPoint(magnifiedX, -magnifiedY);
        }
    }
}

