/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.stress.StressCurve;

public class DistanceStressCurve
extends StressCurve {
    protected static final int SPACE = 20;

    public BufferedImage generate(Dimension size, float alpha, DistanceMatrix projectionDmat, DistanceMatrix originalDmat) throws IOException {
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, size.width, size.height);
        double minrn = originalDmat.getMinDistance();
        double minr2 = projectionDmat.getMinDistance();
        double maxrn = originalDmat.getMaxDistance();
        double maxr2 = projectionDmat.getMaxDistance();
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(10, 20, size.width - 20, 20);
        g2.drawLine(20, 10, 20, size.height - 20);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.RED);
        g2.drawLine(10, 10, size.width - 20, size.height - 20);
        int rgbcolor = Color.BLUE.getRGB();
        for (int i = 0; i < originalDmat.getElementCount(); ++i) {
            for (int j = i + 1; j < originalDmat.getElementCount(); ++j) {
                double distrn = ((double)originalDmat.getDistance(i, j) - minrn) / (maxrn - minrn);
                double distr2 = ((double)projectionDmat.getDistance(i, j) - minr2) / (maxr2 - minr2);
                int x = 40 + (int)((double)(size.width - 60) * distrn);
                int y = 40 + (int)((double)(size.height - 60) * distr2);
                this.simulateAlpha(image, alpha, x, y, rgbcolor);
            }
        }
        BufferedImage refimage = new BufferedImage(size.height, size.width, 1);
        for (int i = 0; i < size.height; ++i) {
            for (int j = 0; j < size.width; ++j) {
                refimage.setRGB(j, i, image.getRGB(j, size.height - i - 1));
            }
        }
        return refimage;
    }

    protected void simulateAlpha(BufferedImage image, float alpha, int x, int y, int rgb) {
        try {
            int oldrgb = image.getRGB(x, y);
            int oldr = oldrgb >> 16 & 0xFF;
            int oldg = oldrgb >> 8 & 0xFF;
            int oldb = oldrgb & 0xFF;
            int newr = (int)(alpha * (float)((rgb >> 16 & 0xFF) - oldr) + (float)oldr);
            int newg = (int)(alpha * (float)((rgb >> 8 & 0xFF) - oldg) + (float)oldg);
            int newb = (int)(alpha * (float)((rgb & 0xFF) - oldb) + (float)oldb);
            int newrgb = newb | newg << 8 | newr << 16;
            image.setRGB(x, y, newrgb);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println(x + "," + y);
        }
    }
}

