/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.agglomerative;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.technique.agglomerative.AgglomerativeTreeComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class AgglomerativeTreeParamView
extends AbstractParametersView {
    protected AgglomerativeTreeComp comp;
    private JComboBox algorithmComboBox;
    private JPanel algorithmPanel;
    private JComboBox dissimilarityComboBox;
    protected JPanel dissimilarityPanel;
    private JButton dmatButton;
    private JPanel dmatFilePanel;
    private JTextField dmatTextField;
    private JLabel jLabel1;

    public AgglomerativeTreeParamView(AgglomerativeTreeComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : AgglomerativeTreeType.values()) {
            this.algorithmComboBox.addItem(enum_);
        }
        this.algorithmComboBox.setSelectedItem((Object)AgglomerativeTreeType.UPGMA);
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.algorithmPanel = new JPanel();
        this.algorithmComboBox = new JComboBox();
        this.dmatFilePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.dmatTextField = new JTextField();
        this.dmatButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Neighbor Joining Connection Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.algorithmPanel.setBorder(BorderFactory.createTitledBorder("Tree Clustering Algorithm"));
        this.algorithmComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgglomerativeTreeParamView.this.algorithmComboBoxActionPerformed(evt);
            }
        });
        this.algorithmPanel.add(this.algorithmComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.algorithmPanel, gridBagConstraints);
        this.dmatFilePanel.setBorder(BorderFactory.createTitledBorder("Distance Matrix File"));
        this.dmatFilePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Distance Matrix File :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.dmatTextField.setMinimumSize(new Dimension(100, 20));
        this.dmatTextField.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.dmatTextField, gridBagConstraints);
        this.dmatButton.setText("Search...");
        this.dmatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgglomerativeTreeParamView.this.dmatButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.dmatButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.dmatFilePanel, gridBagConstraints);
    }

    private void dmatButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.dmatTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AgglomerativeTreeParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void algorithmComboBoxActionPerformed(ActionEvent evt) {
    }

    public void reset() {
        this.dmatFilePanel.setVisible(false);
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
        if (this.comp.agglomerativeTreeType != null) {
            this.algorithmComboBox.setSelectedItem((Object)this.comp.agglomerativeTreeType);
        }
        this.dmatTextField.setText(this.comp.getDmatFile());
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
        if (!this.dmatTextField.getText().isEmpty()) {
            this.comp.setDmatFile(this.dmatTextField.getText());
        }
        this.comp.agglomerativeTreeType = (AgglomerativeTreeType)((Object)this.algorithmComboBox.getSelectedItem());
    }

    public static enum AgglomerativeTreeType {
        UPGMA("UPGMA"),
        WPGMA("WPGMA");

        private final String name;

        private AgglomerativeTreeType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

