/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.agglomerative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class UPGMA {
    public static SimpleTree execute(DistanceMatrix dmat) {
        ContentSimpleTree child2;
        float minClass2;
        String minLabel2;
        int minId2;
        int minIndex2;
        float minClass1;
        String minLabel1;
        int minId1;
        int minIndex1;
        SimpleTree tree = new SimpleTree();
        int maxId = dmat.getElementCount() + 1;
        HashMap<Integer, Float> classMap = new HashMap<Integer, Float>();
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        HashMap<Integer, Float> totalLengthMap = new HashMap<Integer, Float>();
        while (dmat.getElementCount() > 2) {
            int i;
            ContentSimpleTree newNode2;
            minIndex1 = dmat.minDistanceIndices[0];
            minId1 = dmat.getIds().get(minIndex1);
            minLabel1 = dmat.getLabels().get(minIndex1);
            minClass1 = dmat.getClassData()[minIndex1];
            minIndex2 = dmat.minDistanceIndices[1];
            minId2 = dmat.getIds().get(minIndex2);
            minLabel2 = dmat.getLabels().get(minIndex2);
            minClass2 = dmat.getClassData()[minIndex2];
            int newNodeId = maxId++;
            ContentSimpleTree newNode1 = tree.getNodeById(minId1);
            if (newNode1 == null) {
                newNode1 = new ContentSimpleTree(minId1);
                newNode1.setRecursiveChildCount(1);
                newNode1.setKlass(minClass1);
                tree.addNode(newNode1);
                classMap.put(minId1, Float.valueOf(minClass1));
                labelMap.put(minId1, minLabel1);
                totalLengthMap.put(minId1, Float.valueOf(0.0f));
            }
            if ((newNode2 = tree.getNodeById(minId2)) == null) {
                newNode2 = new ContentSimpleTree(minId2);
                newNode2.setRecursiveChildCount(1);
                newNode2.setKlass(minClass2);
                tree.addNode(newNode2);
                classMap.put(minId2, Float.valueOf(minClass2));
                labelMap.put(minId2, minLabel2);
                totalLengthMap.put(minId2, Float.valueOf(0.0f));
            }
            ContentSimpleTree newVirtualNode = new ContentSimpleTree(newNodeId);
            newVirtualNode.setValid(false);
            newVirtualNode.addChildren(minId1, dmat.getMinDistance() / 2.0f - ((Float)totalLengthMap.get(minId1)).floatValue());
            newNode1.setParent(newNodeId);
            newVirtualNode.addChildren(minId2, dmat.getMinDistance() / 2.0f - ((Float)totalLengthMap.get(minId2)).floatValue());
            newNode2.setParent(newNodeId);
            newVirtualNode.setRecursiveChildCount(newNode1.getRecursiveChildCount() + newNode2.getRecursiveChildCount());
            tree.addNode(newVirtualNode);
            totalLengthMap.put(newVirtualNode.getId(), Float.valueOf(dmat.getMinDistance() / 2.0f));
            float[] newNodeDistances = new float[dmat.getElementCount() - 2];
            int newNodeDistancesIndex = 0;
            for (int i2 = 0; i2 < dmat.getElementCount(); ++i2) {
                if (i2 == minIndex1 || i2 == minIndex2) continue;
                double weight1 = (double)newNode1.getRecursiveChildCount() / (double)(newNode1.getRecursiveChildCount() + newNode2.getRecursiveChildCount());
                double weight2 = (double)newNode2.getRecursiveChildCount() / (double)(newNode1.getRecursiveChildCount() + newNode2.getRecursiveChildCount());
                newNodeDistances[newNodeDistancesIndex++] = (float)(weight1 * (double)dmat.getDistance(i2, minIndex1) + weight2 * (double)dmat.getDistance(i2, minIndex2));
            }
            dmat.removeElement(minId1);
            dmat.removeElement(minId2);
            float[][] oldDistances = dmat.getDistmatrix();
            float[][] newDistances = new float[dmat.getElementCount()][];
            for (i = 0; i < dmat.getElementCount(); ++i) {
                newDistances[i] = new float[i + 1];
            }
            for (i = 0; i < newDistances.length - 1; ++i) {
                for (int j = 0; j < oldDistances[i].length; ++j) {
                    newDistances[i][j] = oldDistances[i][j];
                }
            }
            float minDist = dmat.getMinDistance();
            float maxDist = dmat.getMaxDistance();
            int newMinIndex1 = dmat.minDistanceIndices[0];
            int newMinIndex2 = dmat.minDistanceIndices[1];
            int newMaxIndex1 = dmat.maxDistanceIndices[0];
            int newMaxIndex2 = dmat.maxDistanceIndices[1];
            for (int j = 0; j < newNodeDistances.length; ++j) {
                if (newNodeDistances[j] < minDist) {
                    minDist = newNodeDistances[j];
                    newMinIndex1 = dmat.getElementCount();
                    newMinIndex2 = j;
                }
                if (newNodeDistances[j] > maxDist) {
                    maxDist = newNodeDistances[j];
                    newMaxIndex1 = dmat.getElementCount();
                    newMaxIndex2 = j;
                }
                newDistances[dmat.getElementCount() - 1][j] = newNodeDistances[j];
            }
            ArrayList<String> oldLabels = dmat.getLabels();
            oldLabels.add(minLabel1 + "-" + minLabel2);
            ArrayList<Integer> oldIds = dmat.getIds();
            oldIds.add(newNodeId);
            float[] oldClassData = Arrays.copyOf(dmat.getClassData(), dmat.getClassData().length + 1);
            dmat = new DistanceMatrix();
            dmat.setDistmatrix(newDistances);
            dmat.setElementCount(newDistances.length + 1);
            dmat.setIds(oldIds);
            dmat.setLabels(oldLabels);
            dmat.setClassData(oldClassData);
            dmat.setMaxDistance(maxDist);
            dmat.setMinDistance(minDist);
            dmat.maxDistanceIndices = new int[2];
            dmat.maxDistanceIndices[0] = newMaxIndex1;
            dmat.maxDistanceIndices[1] = newMaxIndex2;
            dmat.minDistanceIndices = new int[2];
            dmat.minDistanceIndices[0] = newMinIndex1;
            dmat.minDistanceIndices[1] = newMinIndex2;
        }
        minIndex1 = dmat.minDistanceIndices[0];
        minId1 = dmat.getIds().get(minIndex1);
        minLabel1 = dmat.getLabels().get(minIndex1);
        minClass1 = dmat.getClassData()[minIndex1];
        minIndex2 = dmat.minDistanceIndices[1];
        minId2 = dmat.getIds().get(minIndex2);
        minLabel2 = dmat.getLabels().get(minIndex2);
        minClass2 = dmat.getClassData()[minIndex2];
        ContentSimpleTree rootNode = new ContentSimpleTree(maxId++);
        rootNode.setValid(false);
        ContentSimpleTree child1 = tree.getNodeById(minId1);
        if (child1 == null) {
            child1 = new ContentSimpleTree(minId1);
            child1.setRecursiveChildCount(1);
            child1.setKlass(minClass1);
            tree.addNode(child1);
            classMap.put(minId1, Float.valueOf(minClass1));
            labelMap.put(minId1, minLabel1);
            totalLengthMap.put(minId1, Float.valueOf(0.0f));
        }
        if ((child2 = tree.getNodeById(minId2)) == null) {
            child2 = new ContentSimpleTree(minId2);
            child2.setRecursiveChildCount(1);
            child2.setKlass(minClass2);
            tree.addNode(child2);
            classMap.put(minId2, Float.valueOf(minClass2));
            labelMap.put(minId2, minLabel2);
            totalLengthMap.put(minId2, Float.valueOf(0.0f));
        }
        rootNode.addChildren(minId1, dmat.getDistance(0, 1) / 2.0f - ((Float)totalLengthMap.get(minId1)).floatValue());
        child1.setParent(rootNode.getId());
        rootNode.addChildren(minId2, dmat.getDistance(0, 1) / 2.0f - ((Float)totalLengthMap.get(minId2)).floatValue());
        child2.setParent(rootNode.getId());
        classMap.put(rootNode.getId(), Float.valueOf(0.0f));
        labelMap.put(rootNode.getId(), minLabel1 + "-" + minLabel2);
        tree.addNode(rootNode);
        tree.setClassMap(classMap);
        tree.setLabelMap(labelMap);
        tree.generateEdges();
        return tree;
    }

    public static SimpleTree execute(AbstractMatrix mat, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(mat, diss);
        return UPGMA.execute(dmat);
    }

    public static void main(String[] args) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix("E:\\upgma-livro2.dmat");
        SimpleTree tree = UPGMA.execute(dmat);
        tree.printNodes();
        System.out.println("End!");
    }
}

