/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp.iterative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.neighbors.ANN;
import simpletree.datamining.neighbors.Pair;
import simpletree.datamining.sampling.Sampling;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.CosineBased;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.technique.lsp.CreateNNG;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class LSPProjectionIterative2D
implements Projection {
    private AbstractMatrix sampleproj;
    private AbstractMatrix sampledata;
    private Sampling.SampleType sampletype = Sampling.SampleType.RANDOM;
    private int samplesize = -1;
    private int nrneighbors = 10;
    private float fracdelta = 8.0f;
    private int nriterations = 50;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        long start = System.currentTimeMillis();
        if (this.sampledata == null) {
            if (this.samplesize == -1) {
                this.samplesize = matrix.getRowCount() / 10;
            }
            this.sampledata = this.getSampleData(matrix, diss, this.samplesize);
            this.sampleproj = this.projectSampleData(this.sampledata, diss);
        } else if (this.sampleproj == null) {
            this.sampleproj = this.projectSampleData(this.sampledata, diss);
            this.samplesize = this.sampleproj.getRowCount();
        } else {
            this.samplesize = this.sampleproj.getRowCount();
        }
        ANN appknn = new ANN(this.nrneighbors);
        Pair[][] neighbors = appknn.execute(matrix, diss);
        CreateNNG nng = new CreateNNG();
        nng.execute(neighbors, matrix, diss);
        AbstractMatrix projection = this.projectAll(matrix, diss, neighbors);
        Runtime.getRuntime().gc();
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Least Square Projection (LSP) time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Sampling.SampleType getSampleType() {
        return this.sampletype;
    }

    public void setSampleType(Sampling.SampleType sampletype) {
        this.sampletype = sampletype;
    }

    public int getSampleSize() {
        return this.samplesize;
    }

    public void setSampleSize(int samplesize) {
        this.samplesize = samplesize;
    }

    public void setSampleProjection(AbstractMatrix sampleproj) {
        this.sampleproj = sampleproj;
    }

    public void setSampleMatrix(AbstractMatrix samplematrix) {
        this.sampledata = samplematrix;
    }

    protected AbstractMatrix getSampleData(AbstractMatrix matrix, AbstractDissimilarity diss, int samplesize) throws IOException {
        Sampling sampling = new Sampling(this.sampletype, samplesize);
        AbstractMatrix sampledata_aux = sampling.execute(matrix, diss);
        return sampledata_aux;
    }

    protected AbstractMatrix projectSampleData(AbstractMatrix sample, AbstractDissimilarity diss) throws IOException {
        IDMAPProjection idmap = new IDMAPProjection();
        idmap.setFractionDelta(this.fracdelta);
        idmap.setNumberIterations(this.nriterations);
        this.sampleproj = idmap.project(sample, diss);
        return this.sampleproj;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    private AbstractMatrix projectAll(AbstractMatrix matrix, AbstractDissimilarity diss, Pair[][] neighbors) {
        float dist;
        int j;
        float sum;
        float min;
        float max;
        int i;
        long start = System.currentTimeMillis();
        ArrayList<Integer> ids = matrix.getIds();
        float[] cdata = matrix.getClassData();
        ArrayList<String> labels = matrix.getLabels();
        int[] sampleids_aux = this.getSampleIds(matrix, this.sampledata);
        HashSet<Integer> sampleids = new HashSet<Integer>();
        for (int i2 = 0; i2 < sampleids_aux.length; ++i2) {
            sampleids.add(sampleids_aux[i2]);
        }
        int size = matrix.getRowCount();
        int nr_iterations = (int)Math.sqrt(size);
        float[][] proj = new float[size][2];
        for (i = 0; i < this.samplesize; ++i) {
            proj[sampleids_aux[i]][0] = this.sampleproj.getRow(i).getValues()[0];
            proj[sampleids_aux[i]][1] = this.sampleproj.getRow(i).getValues()[1];
        }
        for (i = 0; i < size; ++i) {
            int j2;
            if (sampleids.contains(i)) continue;
            Pair[] neighbors_cp = new Pair[this.nrneighbors];
            for (j2 = 0; j2 < neighbors_cp.length; ++j2) {
                neighbors_cp[j2] = new Pair(-1, Float.MAX_VALUE);
            }
            block4: for (j2 = 0; j2 < this.samplesize; ++j2) {
                float dist2 = diss.calculate(matrix.getRow(i), this.sampledata.getRow(j2));
                if (!(dist2 < neighbors_cp[neighbors_cp.length - 1].value)) continue;
                for (int k = 0; k < neighbors_cp.length; ++k) {
                    if (!(neighbors_cp[k].value > dist2)) continue;
                    for (int n = neighbors_cp.length - 1; n > k; --n) {
                        neighbors_cp[n].index = neighbors_cp[n - 1].index;
                        neighbors_cp[n].value = neighbors_cp[n - 1].value;
                    }
                    neighbors_cp[k].index = j2;
                    neighbors_cp[k].value = dist2;
                    continue block4;
                }
            }
            max = Float.NEGATIVE_INFINITY;
            min = Float.POSITIVE_INFINITY;
            for (int j3 = 0; j3 < neighbors_cp.length; ++j3) {
                if (max < neighbors_cp[j3].value) {
                    max = neighbors_cp[j3].value;
                }
                if (!(min > neighbors_cp[j3].value)) continue;
                min = neighbors_cp[j3].value;
            }
            sum = 0.0f;
            for (j = 0; j < neighbors_cp.length; ++j) {
                if (!(max > min)) continue;
                dist = (neighbors_cp[j].value - min) / (max - min) * 0.9f + 0.1f;
                sum += 1.0f / dist;
            }
            for (j = 0; j < neighbors_cp.length; ++j) {
                if (max > min) {
                    dist = (neighbors_cp[j].value - min) / (max - min) * 0.9f + 0.1f;
                    float[] fArray = proj[i];
                    fArray[0] = fArray[0] + this.sampleproj.getRow(neighbors_cp[j].index).getValues()[0] * (1.0f / dist / sum);
                    float[] fArray2 = proj[i];
                    fArray2[1] = fArray2[1] + this.sampleproj.getRow(neighbors_cp[j].index).getValues()[1] * (1.0f / dist / sum);
                    continue;
                }
                float[] fArray = proj[i];
                fArray[0] = fArray[0] + this.sampleproj.getRow(neighbors_cp[j].index).getValues()[0] * (1.0f / (float)neighbors_cp.length);
                float[] fArray3 = proj[i];
                fArray3[1] = fArray3[1] + this.sampleproj.getRow(neighbors_cp[j].index).getValues()[1] * (1.0f / (float)neighbors_cp.length);
            }
        }
        for (int k = 0; k < nr_iterations; ++k) {
            for (int i3 = 0; i3 < size; ++i3) {
                if (sampleids.contains(i3)) continue;
                max = Float.NEGATIVE_INFINITY;
                min = Float.POSITIVE_INFINITY;
                for (int j4 = 0; j4 < neighbors[i3].length; ++j4) {
                    if (max < neighbors[i3][j4].value) {
                        max = neighbors[i3][j4].value;
                    }
                    if (!(min > neighbors[i3][j4].value)) continue;
                    min = neighbors[i3][j4].value;
                }
                sum = 0.0f;
                for (j = 0; j < neighbors[i3].length; ++j) {
                    if (!(max > min)) continue;
                    dist = (neighbors[i3][j].value - min) / (max - min) * 0.9f + 0.1f;
                    sum += 1.0f / dist;
                }
                proj[i3][0] = 0.0f;
                proj[i3][1] = 0.0f;
                for (j = 0; j < neighbors[i3].length; ++j) {
                    if (max > min) {
                        dist = (neighbors[i3][j].value - min) / (max - min) * 0.9f + 0.1f;
                        float[] fArray = proj[i3];
                        fArray[0] = fArray[0] + proj[neighbors[i3][j].index][0] * (1.0f / dist / sum);
                        float[] fArray4 = proj[i3];
                        fArray4[1] = fArray4[1] + proj[neighbors[i3][j].index][1] * (1.0f / dist / sum);
                        continue;
                    }
                    float[] fArray = proj[i3];
                    fArray[0] = fArray[0] + proj[neighbors[i3][j].index][0] * (1.0f / (float)neighbors[i3].length);
                    float[] fArray5 = proj[i3];
                    fArray5[1] = fArray5[1] + proj[neighbors[i3][j].index][1] * (1.0f / (float)neighbors[i3].length);
                }
            }
        }
        DenseMatrix projection = new DenseMatrix();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        projection.setAttributes(attributes);
        for (int i4 = 0; i4 < size; ++i4) {
            DenseVector vector = new DenseVector(proj[i4], ids.get(i4), cdata[i4]);
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(vector);
                continue;
            }
            projection.addRow(vector, labels.get(i4));
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using Colt time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    private int[] getSampleIds(AbstractMatrix matrix, AbstractMatrix sample) {
        int i;
        int[] sampleids = new int[sample.getRowCount()];
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        for (i = 0; i < matrix.getRowCount(); ++i) {
            mapping.put(matrix.getRow(i).getId(), i);
        }
        for (i = 0; i < sample.getRowCount(); ++i) {
            sampleids[i] = (Integer)mapping.get(sample.getRow(i).getId());
        }
        return sampleids;
    }

    public static void main(String[] args) throws IOException {
        String filename = "/home/paulovich/Data/PLP_data/segmentation/segmentation-normcols.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(filename);
        ProjectionUtil.log(true, false);
        LSPProjectionIterative2D lsp = new LSPProjectionIterative2D();
        lsp.setNumberNeighbors(12);
        lsp.setSampleType(Sampling.SampleType.CLUSTERING_MEDOID);
        AbstractMatrix projection = lsp.project(matrix, new CosineBased());
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.setTitle("LSP Iterative");
        frame.execute();
    }
}

