/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.msnj;

import java.io.IOException;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.util.MatrixUtils;
import simpletree.technique.msnj.MultiScaleNJ;
import simpletree.technique.msnj.MultiScaleNJConnectionParamView;
import simpletree.technique.packagenj.PackageNJ;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Technique", name="Multi-Scale Neighbor-Joinning", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.", howtocite="ORIGINAL NJ: N. Saitou and M. Nei. The Neighbor-Joining Method: A New Method for Reconstructing Phylogenetic Trees. Molecular Biology and Evolution, 4(4):406\u2013425, 1987 \nRAPID NJ: M. Simonsen, T. Mailund, and C. N. Pedersen. Rapid Neighbour-Joining. In Proceedings of WABI 2008, pages 113\u2013122, Karlsruhe, Germany, September 2008 \nFAST NJ: I. Elias and J. Lagergren. Fast Neighbor Joining. In Proceedings of the 32nd International Colloquium on Automata, Languages and Programming (ICALP\u201905), volume 3580, pages 1263\u20131274, 2005 \nPromotion Procedure: PAIVA, J. G., FLORIAN-CRUZ, L., PEDRINI, H., TELLES, G. P., MINGHIM, R., Improved Similarity Trees and their Application to Visual Data Classification, IEEE Transactions on Visualization and Computer Graphics, v. 17, p. 2459-2468, 2011")
public class MultiScaleNJConnectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private Boolean pnj = false;
    private transient MultiScaleNJConnectionParamView paramview;
    private transient SimpleTree tree;
    private transient AbstractMatrix matrix;
    private PackageNJ.NJAlgorithmType njAlgorithmType = PackageNJ.NJAlgorithmType.RAPID;
    private boolean createSingleRoot = false;
    private int maxId = 0;
    private int levelsExpanded = 1;
    private boolean expandLeafSuperNodes = true;
    private transient MultiscaleData clusterData;

    public void execute() throws IOException {
        long linit;
        MultiScaleNJ hnj = new MultiScaleNJ(this.pnj, this.njAlgorithmType, this.disstype, this.maxId);
        if (this.clusterData != null && this.matrix != null) {
            linit = System.currentTimeMillis();
            if (this.maxId == 0) {
                this.maxId = this.matrix.getRowCount() * 2;
            }
        } else {
            throw new IOException("A points matrix and a multilevel cluster must be provided.");
        }
        hnj.expandLeafClusters = this.expandLeafSuperNodes;
        this.tree = hnj.execute(this.clusterData, this.matrix, this.createSingleRoot, this.levelsExpanded);
        this.tree.setLabelContent(MatrixUtils.getLabelContent(this.matrix));
        long lend = System.currentTimeMillis();
        long l = lend - linit;
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix, @Param(name="clusters") MultiscaleData clusterDataset) {
        this.matrix = matrix;
        this.clusterData = clusterDataset;
        this.maxId = clusterDataset.getMaxClusterId() + 1;
    }

    public SimpleTree output() {
        return this.tree;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new MultiScaleNJConnectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.tree = null;
        this.clusterData = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public Boolean isPnj() {
        if (this.pnj != null) {
            return this.pnj;
        }
        return false;
    }

    public void setPnj(Boolean pnj) {
        this.pnj = pnj;
    }

    public PackageNJ.NJAlgorithmType getNjAlgorithmType() {
        return this.njAlgorithmType;
    }

    public void setNjAlgorithmType(PackageNJ.NJAlgorithmType njAlgorithmType) {
        this.njAlgorithmType = njAlgorithmType;
    }

    public boolean isCreateSingleRoot() {
        return this.createSingleRoot;
    }

    public void setCreateSingleRoot(boolean createSingleRoot) {
        this.createSingleRoot = createSingleRoot;
    }

    public void setMaxId(int m) {
        this.maxId = m;
    }

    public int getLevelsExpanded() {
        return this.levelsExpanded;
    }

    public void setLevelsExpanded(int levelsExpanded) {
        this.levelsExpanded = levelsExpanded;
    }

    public boolean isExpandLeafSuperNodes() {
        return this.expandLeafSuperNodes;
    }

    public void setExpandLeafSuperNodes(boolean expandLeafSuperNodes) {
        this.expandLeafSuperNodes = expandLeafSuperNodes;
    }
}

