/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.packagenj;

import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.basics.SimpleTree;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.technique.packagenj.PackageNJ;
import simpletree.technique.packagenj.PackageNJConnectionParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Technique", name="Neighbor-Joinning Algorithms for Simple Tree", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.", howtocite="ORIGINAL NJ: N. Saitou and M. Nei. The Neighbor-Joining Method: A New Method for Reconstructing Phylogenetic Trees. Molecular Biology and Evolution, 4(4):406\u2013425, 1987 \nRAPID NJ: M. Simonsen, T. Mailund, and C. N. Pedersen. Rapid Neighbour-Joining. In Proceedings of WABI 2008, pages 113\u2013122, Karlsruhe, Germany, September 2008 \nFAST NJ: I. Elias and J. Lagergren. Fast Neighbor Joining. In Proceedings of the 32nd International Colloquium on Automata, Languages and Programming (ICALP\u201905), volume 3580, pages 1263\u20131274, 2005 \nPromotion Procedure: PAIVA, J. G., FLORIAN-CRUZ, L., PEDRINI, H., TELLES, G. P., MINGHIM, R., Improved Similarity Trees and their Application to Visual Data Classification, IEEE Transactions on Visualization and Computer Graphics, v. 17, p. 2459-2468, 2011")
public class PackageNJConnectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private Boolean pnj = false;
    private transient PackageNJConnectionParamView paramview;
    private transient SimpleTree tree;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    private PackageNJ.NJAlgorithmType njAlgorithmType = PackageNJ.NJAlgorithmType.RAPID;
    private String dmatFile;
    private String ninjaDmatFile;
    private boolean createSingleRoot = false;
    private int maxId = 0;

    public void execute() throws IOException {
        PackageNJ nj = new PackageNJ(this.pnj, this.njAlgorithmType);
        if (this.dmatFile != null && !this.dmatFile.trim().isEmpty()) {
            this.matrix = null;
            this.dmat = null;
            try {
                this.tree = nj.execute(this.dmatFile, this.maxId);
            }
            catch (ParseException ex) {
                Logger.getLogger(PackageNJConnectionComp.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.tree = nj.execute(this.matrix, diss, this.createSingleRoot, this.maxId);
            if (this.tree != null) {
                this.tree.updateRecursiveChildCount();
            } else {
                Logger.getLogger(PackageNJConnectionComp.class.getName()).log(Level.SEVERE, "#Tree is null");
            }
        } else if (this.dmat != null) {
            this.tree = nj.execute(this.dmat, this.createSingleRoot, this.maxId);
            this.tree.printNodes();
            if (this.tree != null) {
                this.tree.updateRecursiveChildCount();
            } else {
                System.out.println("A arvore eh null!");
            }
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public SimpleTree output() {
        return this.tree;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new PackageNJConnectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }

    public Boolean isPnj() {
        if (this.pnj != null) {
            return this.pnj;
        }
        return false;
    }

    public void setPnj(Boolean pnj) {
        this.pnj = pnj;
    }

    public PackageNJ.NJAlgorithmType getNjAlgorithmType() {
        return this.njAlgorithmType;
    }

    public void setNjAlgorithmType(PackageNJ.NJAlgorithmType njAlgorithmType) {
        this.njAlgorithmType = njAlgorithmType;
    }

    public String getDmatFile() {
        return this.dmatFile;
    }

    public void setDmatFile(String text) {
        this.dmatFile = text;
    }

    public String getNinjaDistanceMatrixFile() {
        return this.ninjaDmatFile;
    }

    public void setNinjaDistanceMatrixFile(String text) {
        this.ninjaDmatFile = text;
    }

    public boolean isCreateSingleRoot() {
        return this.createSingleRoot;
    }

    public void setCreateSingleRoot(boolean createSingleRoot) {
        this.createSingleRoot = createSingleRoot;
    }

    public void setMaxId(int m) {
        this.maxId = m;
    }
}

