/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.ColorTable;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.technique.parallelcoordinates.model.PolylineInstance;
import simpletree.technique.parallelcoordinates.model.Silhouette;

public class ParallelCoordinatesModel
extends AbstractModel {
    private float[] silhouettes;
    private ArrayList<String> attributes;
    private float alpha;
    private ColorTable ctable;
    private PolylineNormalizationType norm;
    private float minklass;
    private float maxklass;
    private float[] minvalues;
    private float[] maxvalues;
    private boolean drawverticalaxes;
    private boolean drawaxelables;
    private boolean drawsilhouette;
    private Dimension size;
    private boolean coloredinstances;

    public ParallelCoordinatesModel(ArrayList<String> attributes) {
        this.attributes = attributes;
        this.minklass = Float.POSITIVE_INFINITY;
        this.maxklass = Float.NEGATIVE_INFINITY;
        this.maxvalues = null;
        this.minvalues = null;
        this.norm = PolylineNormalizationType.COLUMN_INDEPENDENT;
        this.alpha = 1.0f;
        this.drawaxelables = true;
        this.drawverticalaxes = true;
        this.drawsilhouette = true;
        this.coloredinstances = true;
        this.setSize(800, 600);
        this.setColorTable(new ColorTable(ColorScaleFactory.ColorScaleType.PSEUDO_RAINBOW_SCALE));
    }

    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            int i;
            for (int i2 = 0; i2 < this.instances.size(); ++i2) {
                PolylineInstance pi = (PolylineInstance)this.instances.get(i2);
                if (pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            int width = image.getWidth() - 20;
            int height = image.getHeight() - 60;
            int space = width / this.maxvalues.length;
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            for (i = 0; i < this.maxvalues.length; ++i) {
                int x1 = 10 + i * space;
                int y1 = 50;
                int x2 = x1;
                int y2 = 50 + height;
                if (this.drawaxelables && this.attributes.size() == this.maxvalues.length) {
                    g2.setFont(new Font("SansSerif", 0, 10));
                    String label = this.attributes.get(i);
                    try {
                        double value = Float.parseFloat(label);
                        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
                        df.applyPattern("0.00E0");
                        label = df.format(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    g2.setColor(Color.BLACK);
                    g2.drawString(label, x1 - 5, y1 - 5);
                    g2.setColor(Color.WHITE);
                    g2.fillRect(x1 + space - 10, y1 - 50, width, 50);
                }
                if (this.drawsilhouette && this.silhouettes != null) {
                    if (this.silhouettes[i] > 0.0f) {
                        g2.setColor(Color.BLUE);
                    } else if (this.silhouettes[i] < 0.0f) {
                        g2.setColor(Color.RED);
                    } else {
                        g2.setColor(Color.WHITE);
                    }
                    g2.fillRect(x1 - 5, y1 - 30, (int)((this.silhouettes[i] + 1.0f) / 2.0f * (float)(space - 5)), 10);
                    g2.setColor(Color.BLACK);
                    g2.drawRect(x1 - 5, y1 - 30, space - 5, 10);
                }
                if (!this.drawverticalaxes) continue;
                g2.setColor(Color.BLACK);
                g2.drawLine(x1, y1, x2, y2);
            }
            for (i = 0; i < this.instances.size(); ++i) {
                PolylineInstance pi = (PolylineInstance)this.instances.get(i);
                if (!pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
        }
    }

    @Override
    public void addInstance(AbstractInstance instance) {
        super.addInstance(instance);
        this.updateKlassRange(((PolylineInstance)instance).getKlass());
        this.updateValuesRange(((PolylineInstance)instance).getOriginalValues());
    }

    public void updateKlassRange(float value) {
        if (this.maxklass < value) {
            this.maxklass = value;
        }
        if (this.minklass > value) {
            this.minklass = value;
        }
    }

    public void updateValuesRange(float[] values) {
        if (this.maxvalues == null) {
            this.maxvalues = new float[values.length];
            this.minvalues = new float[values.length];
            Arrays.fill(this.maxvalues, Float.NEGATIVE_INFINITY);
            Arrays.fill(this.minvalues, Float.POSITIVE_INFINITY);
        }
        if (this.maxvalues.length == values.length) {
            for (int i = 0; i < values.length; ++i) {
                if (this.maxvalues[i] < values[i]) {
                    this.maxvalues[i] = values[i];
                }
                if (!(this.minvalues[i] > values[i])) continue;
                this.minvalues[i] = values[i];
            }
        } else {
            throw new RuntimeException("ERROR: trying to add an instance of different size!");
        }
    }

    public float[] getMaxValues() {
        return this.maxvalues;
    }

    public float[] getMinValues() {
        return this.minvalues;
    }

    public float getMaxKlass() {
        return this.maxklass;
    }

    public float getMinKlass() {
        return this.minklass;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Dimension getSize() {
        return this.size;
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }

    public boolean isColoredInstances() {
        return this.coloredinstances;
    }

    public void setColoredInstances(boolean value) {
        this.coloredinstances = value;
        this.setChanged();
    }

    public boolean isDrawVerticalAxes() {
        return this.drawverticalaxes;
    }

    public void setDrawVerticalAxes(boolean value) {
        this.drawverticalaxes = value;
        this.setChanged();
    }

    public boolean isDrawAxeLabels() {
        return this.drawaxelables;
    }

    public void setDrawAxeLabels(boolean value) {
        this.drawaxelables = value;
        this.setChanged();
    }

    public boolean isDrawSilhouetteBoxes() {
        return this.drawsilhouette;
    }

    public void setDrawSilhouetteBoxes(boolean value) {
        this.drawsilhouette = value;
        this.setChanged();
    }

    public PolylineNormalizationType getNormalization() {
        return this.norm;
    }

    public void setNormalization(PolylineNormalizationType norm) {
        this.norm = norm;
        for (int i = 0; i < this.instances.size(); ++i) {
            ((PolylineInstance)this.instances.get(i)).calculateScreenPositions();
        }
        this.setChanged();
    }

    public void setSize(int width, int height) {
        if (this.size == null) {
            this.size = new Dimension();
        }
        this.size.width = width;
        this.size.height = height;
        for (int i = 0; i < this.instances.size(); ++i) {
            ((PolylineInstance)this.instances.get(i)).calculateScreenPositions();
        }
        this.setChanged();
    }

    public void setAlpha(float value) {
        if (value >= 0.0f && value <= 1.0f) {
            this.alpha = value;
            this.setChanged();
        }
    }

    public ColorTable getColorTable() {
        return this.ctable;
    }

    public void setColorTable(ColorTable ctable) {
        this.ctable = ctable;
        for (int i = 0; i < this.instances.size(); ++i) {
            ((PolylineInstance)this.instances.get(i)).calculateColor();
        }
        this.setChanged();
    }

    public AbstractVector getColumn(int col) {
        float[] vect = new float[this.instances.size()];
        for (int i = 0; i < vect.length; ++i) {
            vect[i] = ((PolylineInstance)this.instances.get(i)).getOriginalValues()[col];
        }
        DenseVector vector = new DenseVector(vect, col);
        return vector;
    }

    public void calculateSilhouette() {
        this.silhouettes = new float[this.maxvalues.length];
        Arrays.fill(this.silhouettes, 0.0f);
        Silhouette sil = new Silhouette();
        for (int i = 0; i < this.silhouettes.length; ++i) {
            this.silhouettes[i] = sil.calculate(this.instances, new int[]{i});
        }
        this.setChanged();
    }

    public ArrayList<PolylineInstance> getInstancesByPosition(Rectangle rect) {
        int width = this.size.width - 20;
        int space = width / this.maxvalues.length;
        int iniaxe = -1;
        int finaxe = -1;
        for (int i = 0; i < this.maxvalues.length; ++i) {
            int x = 10 + i * space;
            if (x < rect.x || x > rect.x + rect.width) continue;
            if (iniaxe == -1) {
                iniaxe = i;
                finaxe = i;
                continue;
            }
            finaxe = i;
        }
        ArrayList<PolylineInstance> selected = new ArrayList<PolylineInstance>();
        for (int i = 0; i < this.instances.size(); ++i) {
            PolylineInstance pi = (PolylineInstance)this.instances.get(i);
            if (iniaxe < 0 || !pi.isInside(rect, iniaxe, finaxe)) continue;
            selected.add(pi);
        }
        return selected;
    }

    public PolylineInstance getInstanceByPosition(Point point) {
        for (int i = 0; i < this.instances.size(); ++i) {
            PolylineInstance pi = (PolylineInstance)this.instances.get(i);
            if (!pi.isInside(point.x, point.y)) continue;
            return pi;
        }
        return null;
    }

    public static enum PolylineNormalizationType {
        COLUMN_INDEPENDENT("Normlize columns individually"),
        COLUMN_ALL("Normalize all data");

        private final String name;

        private PolylineNormalizationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

