/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model.view;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.coordination.AbstractCoordinator;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;
import simpletree.technique.parallelcoordinates.model.view.ParallelCoordinatesFrame;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Parallel Coordinates.View", name="Parallel Coordinates View Frame", description="Display parallel coordinates model.")
public class ParallelCoordinatesFrameComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String title = "";
    private transient ParallelCoordinatesModel model;
    private transient ArrayList<AbstractCoordinator> coordinators;

    public void execute() throws IOException {
        if (this.model != null) {
            ParallelCoordinatesFrame frame = new ParallelCoordinatesFrame();
            frame.setSize(600, 600);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
            frame.setTitle(this.title);
            frame.setModel(this.model);
            if (this.coordinators != null) {
                for (int i = 0; i < this.coordinators.size(); ++i) {
                    frame.addCoordinator(this.coordinators.get(i));
                }
            }
        } else {
            throw new IOException("A parallel coordinates model should be provided.");
        }
    }

    public void input(@Param(name="parallel coordinates model") ParallelCoordinatesModel model) {
        this.model = model;
    }

    public void attach(@Param(name="coordinator") AbstractCoordinator coordinator) {
        if (this.coordinators == null) {
            this.coordinators = new ArrayList();
        }
        if (coordinator != null) {
            this.coordinators.add(coordinator);
        }
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.model = null;
        this.coordinators = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }
}

