/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.database;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.h2.tools.Script;

public class ConnectionManager {
    private final String temp = "./data_base/temp.sql";
    private final String properties = "./config/database.properties";
    private Connection conn;
    private static ConnectionManager _instance;

    private ConnectionManager() throws IOException {
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(this.properties);
            props.load(in);
            String drivers = props.getProperty("jdbc.driver");
            String url = props.getProperty("jdbc.url");
            String username = props.getProperty("jdbc.username");
            String password = props.getProperty("jdbc.password");
            Class.forName(drivers);
            this.conn = DriverManager.getConnection(url, username, password);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void dispose() throws IOException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException(ex.getMessage());
            }
        }
        _instance = null;
    }

    public static ConnectionManager getInstance() throws IOException {
        if (_instance == null) {
            _instance = new ConnectionManager();
        }
        return _instance;
    }

    public static void compress() throws IOException {
        try {
            ConnectionManager.getInstance().dispose();
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(ConnectionManager.getInstance().properties);
            props.load(in);
            String url = props.getProperty("jdbc.url");
            String username = props.getProperty("jdbc.username");
            String password = props.getProperty("jdbc.password");
            String dir = props.getProperty("jdbc.dir");
            String database = props.getProperty("jdbc.database");
            Script.execute((String)url, (String)username, (String)password, (String)ConnectionManager.getInstance().temp);
            DeleteDbFiles.execute((String)dir, (String)database, (boolean)true);
            RunScript.execute((String)url, (String)username, (String)password, (String)ConnectionManager.getInstance().temp, null, (boolean)false);
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }
}

