/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.zip;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.corpus.zip.InvertedZipCorpus;
import simpletree.textprocessing.processing.Ngram;
import simpletree.util.Util;

public class ZipCorpus
extends Corpus {
    private HashMap<Integer, String> idtourl = new HashMap();
    private InvertedZipCorpus invCorpus;

    public ZipCorpus(String url, int nrGrams) {
        super(url, nrGrams);
        this.run();
        String invCorpFilename = this.url.substring(0, this.url.length() - 4) + ".inv";
        this.invCorpus = new InvertedZipCorpus(this, nrGrams, invCorpFilename);
    }

    @Override
    public String getLabel(int nrlines, int id) throws IOException {
        String label = this.idToUrl(id);
        return label;
    }

    @Override
    public String getViewContent(int id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getViewContent(String itemUrl) throws IOException {
        return this.getFullContent(itemUrl);
    }

    @Override
    public String getSearchContent(int id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getFullContent(int id) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(this.url);
            String urlName = this.idToUrl(id);
            ZipEntry entry = zip.getEntry(urlName);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), Corpus.getEncoding().toString()));
                StringBuffer text = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    text.append(line + "\r\n");
                }
                String string = text.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new IOException("File " + this.idToUrl(id) + " does not exist.");
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    @Override
    public String getFullContent(String itemUrl) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(this.url);
            ZipEntry entry = zip.getEntry(itemUrl);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), Corpus.getEncoding().toString()));
                StringBuffer text = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    text.append(line + "\r\n");
                }
                String string = text.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new IOException("File " + itemUrl + " does not exist.");
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    @Override
    public String getFilteredContent(int id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public ArrayList<Ngram> getCorpusNgrams() throws IOException {
        return this.invCorpus.getCorpusNgrams();
    }

    @Override
    public ArrayList<Ngram> getNgrams(int id) throws IOException {
        return this.invCorpus.getNgrams(id);
    }

    public String idToUrl(int id) {
        return this.idtourl.get(id);
    }

    @Override
    protected void run() {
        this.createIndex();
        this.createCdata();
    }

    private void createCdata() {
        if (this.url != null && this.ids != null) {
            int i;
            ArrayList<String> initials_aux = new ArrayList<String>();
            for (int i2 = 0; i2 < this.ids.size(); ++i2) {
                String filename = this.idToUrl((Integer)this.ids.get(i2));
                int begin = filename.lastIndexOf("/");
                if (begin > -1) {
                    filename = filename.substring(begin + 1);
                }
                String ini = filename;
                if (filename.length() > 2) {
                    ini = filename.substring(0, 2);
                }
                if (initials_aux.contains(ini)) continue;
                initials_aux.add(ini);
            }
            Object[] initials = new String[initials_aux.size()];
            for (i = 0; i < initials_aux.size(); ++i) {
                initials[i] = (String)initials_aux.get(i);
            }
            Arrays.sort(initials);
            if (initials.length > 1) {
                this.cdata = new float[this.ids.size()];
                for (i = 0; i < this.ids.size(); ++i) {
                    this.cdata[i] = -1.0f;
                    for (int j = 0; j < initials.length; ++j) {
                        String filename = this.idToUrl((Integer)this.ids.get(i));
                        int begin = filename.lastIndexOf("/");
                        if (begin > -1) {
                            filename = filename.substring(begin + 1);
                        }
                        if (!filename.startsWith((String)initials[j])) continue;
                        this.cdata[i] = j;
                    }
                }
            } else {
                this.cdata = new float[this.ids.size()];
                Arrays.fill(this.cdata, 0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex() {
        if (this.url != null) {
            this.ids = new ArrayList();
            HashSet<Integer> uniques = new HashSet<Integer>();
            ZipFile zip = null;
            try {
                zip = new ZipFile(this.url);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry2;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                    String filename = entry2.getName();
                    int id = Util.convertToInt(filename);
                    this.ids.add(id);
                    uniques.add(id);
                    this.idtourl.put(id, filename);
                }
                if (this.ids.size() != uniques.size()) {
                    throw new IOException("There are some non-unique ids: " + this.ids.size() + " != " + uniques.size());
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        ZipCorpus corpus = new ZipCorpus("D:\\Meus documentos\\FERNANDO\\Corpora\\cbr-ilp-ir.zip", 1);
        for (int id : corpus.getIds()) {
            try {
                System.out.println(corpus.getFullContent(id));
                System.out.println("##############");
            }
            catch (IOException ex) {
                Logger.getLogger(ZipCorpus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

