/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.stemmer;

import org.tartarus.snowball.ext.englishStemmer;
import org.tartarus.snowball.ext.frenchStemmer;
import org.tartarus.snowball.ext.porterStemmer;
import org.tartarus.snowball.ext.portugueseStemmer;
import org.tartarus.snowball.ext.spanishStemmer;
import simpletree.textprocessing.processing.stemmer.NoneStemmer;
import simpletree.textprocessing.processing.stemmer.SnowBallWrapper;
import simpletree.textprocessing.processing.stemmer.Stemmer;

public class StemmerFactory {
    public static Stemmer getInstance(StemmerType type) {
        if (type == StemmerType.PORTER) {
            return new SnowBallWrapper(porterStemmer.class);
        }
        if (type == StemmerType.ENGLISH) {
            return new SnowBallWrapper(englishStemmer.class);
        }
        if (type == StemmerType.PORTUGUESE) {
            return new SnowBallWrapper(portugueseStemmer.class);
        }
        if (type == StemmerType.SPANISH) {
            return new SnowBallWrapper(spanishStemmer.class);
        }
        if (type == StemmerType.FRENCH) {
            return new SnowBallWrapper(frenchStemmer.class);
        }
        return new NoneStemmer();
    }

    public static enum StemmerType {
        NONE("None"),
        PORTER("Porter's stemmer"),
        ENGLISH("English stemmer"),
        PORTUGUESE("Portuguese stemmer"),
        SPANISH("Spanish stemmer"),
        FRENCH("French stemmer");

        private final String name;

        private StemmerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

