/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import java.io.IOException;
import simpletree.matrix.AbstractMatrix;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.MatrixTransformationFactory;
import simpletree.textprocessing.processing.transformation.MatrixTransformationParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Text Processing", name="Matrix Transformation", description="Transform a \"documents x terms\" matrix weighting the terms according to some measure.", howtocite="Salton, G.; Buckley, C. Term-weighting approaches in automatic text retrieval.Information Processing & Management, v. 24, n. 5, p. 513\ufffd523, 1988.")
public class MatrixTransformationComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private MatrixTransformationFactory.MatrixTransformationType matrixtrans = MatrixTransformationFactory.MatrixTransformationType.TF_IDF;
    private transient MatrixTransformationParamView paramview;
    private transient AbstractMatrix input;
    private transient AbstractMatrix output;

    public void execute() throws IOException {
        MatrixTransformation trans = MatrixTransformationFactory.getInstance(this.matrixtrans);
        this.output = trans.tranform(this.input, null);
    }

    public void input(@Param(name="\"documents x terms\" matrix") AbstractMatrix input) {
        this.input = input;
    }

    public AbstractMatrix output() {
        return this.output;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new MatrixTransformationParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.input = null;
        this.output = null;
    }

    public MatrixTransformationFactory.MatrixTransformationType getMatrixTransformationType() {
        return this.matrixtrans;
    }

    public void setMatrixTransformationType(MatrixTransformationFactory.MatrixTransformationType matrixtrans) {
        this.matrixtrans = matrixtrans;
    }
}

