/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.NTFIDFTransformation;
import simpletree.textprocessing.processing.transformation.NTFTransformation;
import simpletree.textprocessing.processing.transformation.ParaconsistentParametersView;
import simpletree.textprocessing.processing.transformation.TFIDFParaTransformation;
import simpletree.textprocessing.processing.transformation.TFIDFTransformation;

public class MatrixTransformationFactory {
    public static MatrixTransformation getInstance(MatrixTransformationType type) {
        if (type.equals((Object)MatrixTransformationType.NTF)) {
            return new NTFTransformation();
        }
        if (type.equals((Object)MatrixTransformationType.NTF_IDF)) {
            return new NTFIDFTransformation();
        }
        if (type.equals((Object)MatrixTransformationType.TF_IDF)) {
            return new TFIDFTransformation();
        }
        if (type.equals((Object)MatrixTransformationType.PARA_TF_IDF)) {
            ParaconsistentParametersView pView = ParaconsistentParametersView.getInstance();
            pView.display();
            TFIDFParaTransformation paraTransform = new TFIDFParaTransformation();
            paraTransform.setParaconsistentParameters(pView.getParaconsistentParameters());
            return paraTransform;
        }
        return null;
    }

    public static enum MatrixTransformationType {
        NTF("Normalized term-frequency"),
        NTF_IDF("Normalized term-frequency inverse-document-frequency"),
        TF_IDF("Term-frequency inverse-document-frequency"),
        PARA_TF_IDF("Paraconsistent-TF-IDF");

        private final String name;

        private MatrixTransformationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

