/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.Ngram;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.textprocessing.processing.view.StopwordsManager;
import simpletree.textprocessing.processing.view.ZipfCurve;

public class LuhnCutAnalizer
extends JDialog {
    private StemmerFactory.StemmerType stemmertype;
    private int nrgrams;
    private DefaultTableModel tableModel;
    private Corpus corpus;
    private JButton analyzeButton;
    private JPanel buttonPanel;
    private JButton changeStopwordsButton;
    protected JButton closeButton;
    private JPanel cutConfigurationPanel;
    private JButton loerCutMinusButton;
    private JPanel lowerCutButtonPanel;
    private JLabel lowerCutLabel;
    private JPanel lowerCutPanel;
    private JButton lowerCutPlusButton;
    protected JSlider lowerCutSlider;
    protected JTextField lowerCutTextField;
    private JPanel luhnPanel;
    private JLabel ngramsLabel;
    private JPanel ngramsPanel;
    private JScrollPane ngramsScrollPane;
    protected JTable ngramsTable;
    protected JTextField ngramsTextField;
    private JPanel numberGramsPanel;
    private JPanel upperCutButtonPanel;
    private JLabel upperCutLabel;
    private JButton upperCutMinusButton;
    private JPanel upperCutPanel;
    private JButton upperCutPlusButton;
    protected JSlider upperCutSlider;
    protected JTextField upperCutTextField;
    protected JPanel zipfCurvePanel;
    private JPanel zipfPanel;

    private LuhnCutAnalizer(JFrame parent) {
        super(parent);
        this.initModels();
        this.initComponents();
        this.setPreferredSize(new Dimension(700, 550));
        this.setSize(700, 550);
    }

    private void initComponents() {
        this.luhnPanel = new JPanel();
        this.zipfPanel = new JPanel();
        this.zipfCurvePanel = new ZipfCurve();
        this.cutConfigurationPanel = new JPanel();
        this.upperCutPanel = new JPanel();
        this.upperCutSlider = new JSlider();
        this.upperCutLabel = new JLabel();
        this.upperCutButtonPanel = new JPanel();
        this.upperCutTextField = new JTextField();
        this.upperCutPlusButton = new JButton();
        this.upperCutMinusButton = new JButton();
        this.lowerCutPanel = new JPanel();
        this.lowerCutSlider = new JSlider();
        this.lowerCutButtonPanel = new JPanel();
        this.lowerCutTextField = new JTextField();
        this.lowerCutPlusButton = new JButton();
        this.loerCutMinusButton = new JButton();
        this.lowerCutLabel = new JLabel();
        this.ngramsPanel = new JPanel();
        this.numberGramsPanel = new JPanel();
        this.ngramsLabel = new JLabel();
        this.ngramsTextField = new JTextField();
        this.ngramsScrollPane = new JScrollPane();
        this.ngramsTable = new JTable();
        this.changeStopwordsButton = new JButton();
        this.buttonPanel = new JPanel();
        this.analyzeButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Luhn's cut-off Analysis");
        this.setModal(true);
        this.luhnPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.luhnPanel.setLayout(new BorderLayout());
        this.zipfPanel.setBorder(BorderFactory.createTitledBorder("Zipf's Curve"));
        this.zipfPanel.setLayout(new BorderLayout());
        this.zipfPanel.add((Component)this.zipfCurvePanel, "Center");
        this.luhnPanel.add((Component)this.zipfPanel, "Center");
        this.cutConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Cut-off Configuration"));
        this.cutConfigurationPanel.setLayout(new BorderLayout());
        this.upperCutPanel.setLayout(new BorderLayout());
        this.upperCutSlider.setMajorTickSpacing(1);
        this.upperCutSlider.setSnapToTicks(true);
        this.upperCutSlider.setValue(0);
        this.upperCutSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LuhnCutAnalizer.this.upperCutSliderStateChanged(evt);
            }
        });
        this.upperCutPanel.add((Component)this.upperCutSlider, "Center");
        this.upperCutLabel.setText("Upper Cut");
        this.upperCutPanel.add((Component)this.upperCutLabel, "West");
        this.upperCutButtonPanel.setLayout(new GridBagLayout());
        this.upperCutTextField.setColumns(5);
        this.upperCutTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.upperCutButtonPanel.add((Component)this.upperCutTextField, gridBagConstraints);
        this.upperCutPlusButton.setText("+");
        this.upperCutPlusButton.setPreferredSize(new Dimension(43, 15));
        this.upperCutPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.upperCutPlusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.upperCutButtonPanel.add((Component)this.upperCutPlusButton, gridBagConstraints);
        this.upperCutMinusButton.setText("-");
        this.upperCutMinusButton.setPreferredSize(new Dimension(39, 15));
        this.upperCutMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.upperCutMinusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.upperCutButtonPanel.add((Component)this.upperCutMinusButton, gridBagConstraints);
        this.upperCutPanel.add((Component)this.upperCutButtonPanel, "East");
        this.cutConfigurationPanel.add((Component)this.upperCutPanel, "South");
        this.lowerCutPanel.setLayout(new BorderLayout());
        this.lowerCutSlider.setMajorTickSpacing(1);
        this.lowerCutSlider.setSnapToTicks(true);
        this.lowerCutSlider.setValue(0);
        this.lowerCutSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LuhnCutAnalizer.this.lowerCutSliderStateChanged(evt);
            }
        });
        this.lowerCutPanel.add((Component)this.lowerCutSlider, "Center");
        this.lowerCutButtonPanel.setLayout(new GridBagLayout());
        this.lowerCutTextField.setColumns(5);
        this.lowerCutTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.lowerCutButtonPanel.add((Component)this.lowerCutTextField, gridBagConstraints);
        this.lowerCutPlusButton.setText("+");
        this.lowerCutPlusButton.setPreferredSize(new Dimension(43, 15));
        this.lowerCutPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.lowerCutPlusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.lowerCutButtonPanel.add((Component)this.lowerCutPlusButton, gridBagConstraints);
        this.loerCutMinusButton.setText("-");
        this.loerCutMinusButton.setPreferredSize(new Dimension(39, 15));
        this.loerCutMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.loerCutMinusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.lowerCutButtonPanel.add((Component)this.loerCutMinusButton, gridBagConstraints);
        this.lowerCutPanel.add((Component)this.lowerCutButtonPanel, "East");
        this.lowerCutLabel.setText("Lower Cut");
        this.lowerCutPanel.add((Component)this.lowerCutLabel, "West");
        this.cutConfigurationPanel.add((Component)this.lowerCutPanel, "North");
        this.luhnPanel.add((Component)this.cutConfigurationPanel, "South");
        this.ngramsPanel.setLayout(new GridBagLayout());
        this.ngramsLabel.setText("Number ngrams");
        this.numberGramsPanel.add(this.ngramsLabel);
        this.ngramsTextField.setColumns(5);
        this.ngramsTextField.setEditable(false);
        this.numberGramsPanel.add(this.ngramsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.ngramsPanel.add((Component)this.numberGramsPanel, gridBagConstraints);
        this.ngramsScrollPane.setBorder(BorderFactory.createTitledBorder("Ngrams and Frequency"));
        this.ngramsScrollPane.setPreferredSize(new Dimension(230, 275));
        this.ngramsTable.setModel(this.tableModel);
        this.ngramsTable.setEnabled(false);
        this.ngramsScrollPane.setViewportView(this.ngramsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.ngramsPanel.add((Component)this.ngramsScrollPane, gridBagConstraints);
        this.changeStopwordsButton.setText("Change Stopwords");
        this.changeStopwordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.changeStopwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.ngramsPanel.add((Component)this.changeStopwordsButton, gridBagConstraints);
        this.luhnPanel.add((Component)this.ngramsPanel, "East");
        this.getContentPane().add((Component)this.luhnPanel, "Center");
        this.analyzeButton.setText("Analyze");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.analyzeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.analyzeButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void upperCutMinusButtonActionPerformed(ActionEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        this.upperCutSlider.setValue(upperCut + 1);
    }

    private void upperCutPlusButtonActionPerformed(ActionEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        this.upperCutSlider.setValue(upperCut - 1);
    }

    private void loerCutMinusButtonActionPerformed(ActionEvent evt) {
        int lowerCut = this.lowerCutSlider.getValue();
        this.lowerCutSlider.setValue(lowerCut + 1);
    }

    private void lowerCutPlusButtonActionPerformed(ActionEvent evt) {
        int lowerCut = this.lowerCutSlider.getValue();
        this.lowerCutSlider.setValue(lowerCut - 1);
    }

    private void changeStopwordsButtonActionPerformed(ActionEvent evt) {
        StopwordsManager.getInstance(this).display();
        this.analyze();
    }

    private void lowerCutSliderStateChanged(ChangeEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        int lowerCut = this.lowerCutSlider.getValue();
        int[] freqs = ((ZipfCurve)this.zipfCurvePanel).setCutLines(lowerCut, upperCut);
        this.lowerCutTextField.setText(Integer.toString(freqs[0]));
        this.upperCutTextField.setText(Integer.toString(freqs[1]));
        this.ngramsTable.setRowSelectionInterval(upperCut, lowerCut);
        this.ngramsTextField.setText(Integer.toString(lowerCut - upperCut + 1));
        if (this.lowerCutSlider.getValue() < this.upperCutSlider.getValue()) {
            this.upperCutSlider.setValue(this.lowerCutSlider.getValue());
        }
    }

    private void upperCutSliderStateChanged(ChangeEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        int lowerCut = this.lowerCutSlider.getValue();
        int[] freqs = ((ZipfCurve)this.zipfCurvePanel).setCutLines(lowerCut, upperCut);
        this.lowerCutTextField.setText(Integer.toString(freqs[0]));
        this.upperCutTextField.setText(Integer.toString(freqs[1]));
        this.ngramsTable.setRowSelectionInterval(upperCut, lowerCut);
        this.ngramsTextField.setText(Integer.toString(lowerCut - upperCut + 1));
        if (this.upperCutSlider.getValue() > this.lowerCutSlider.getValue()) {
            this.lowerCutSlider.setValue(this.upperCutSlider.getValue());
        }
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        this.analyze();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static LuhnCutAnalizer getInstance(JFrame parent) {
        return new LuhnCutAnalizer(parent);
    }

    public void display(Corpus corpus, StemmerFactory.StemmerType stemmertype, int nrgrams) {
        this.corpus = corpus;
        this.stemmertype = stemmertype;
        this.nrgrams = nrgrams;
        this.upperCutTextField.setText("");
        this.lowerCutTextField.setText("");
        this.ngramsTextField.setText("");
        this.lowerCutSlider.setEnabled(false);
        this.lowerCutSlider.setValue(0);
        this.upperCutSlider.setEnabled(false);
        this.upperCutSlider.setValue(0);
        ((ZipfCurve)this.zipfCurvePanel).setNgrams(null);
        this.initModels();
        this.ngramsTable.setModel(this.tableModel);
        this.analyze();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public int getLowerCut() {
        if (this.lowerCutTextField.getText().trim().length() > 0) {
            return Integer.parseInt(this.lowerCutTextField.getText());
        }
        return 0;
    }

    public int getUpperCut() {
        if (this.upperCutTextField.getText().trim().length() > 0) {
            return Integer.parseInt(this.upperCutTextField.getText());
        }
        return 0;
    }

    protected void countWordsFrequency(HashMap<String, Ngram> corporaNgrams) throws IOException {
        Preprocessor pre = new Preprocessor(this.corpus);
        ArrayList<Ngram> ngrams = pre.getNgramsAccordingTo(1, -1, this.nrgrams, this.stemmertype);
        for (Ngram n : ngrams) {
            corporaNgrams.put(n.ngram, n);
        }
    }

    protected void initModels() {
        Object[] titulos = new String[]{"Ngram", "Frequency"};
        this.tableModel = new DefaultTableModel(null, titulos);
    }

    protected void analyze() {
        try {
            HashMap<String, Ngram> corpusngrams = new HashMap<String, Ngram>();
            this.countWordsFrequency(corpusngrams);
            ArrayList<Ngram> ngrams = new ArrayList<Ngram>();
            for (String key : corpusngrams.keySet()) {
                ngrams.add(corpusngrams.get(key));
            }
            Collections.sort(ngrams);
            this.initModels();
            this.ngramsTable.setModel(this.tableModel);
            for (int i = 0; i < ngrams.size(); ++i) {
                Object[] label = new String[]{ngrams.get((int)i).ngram, Integer.toString(ngrams.get((int)i).frequency)};
                this.tableModel.addRow(label);
            }
            ((ZipfCurve)this.zipfCurvePanel).setNgrams(ngrams);
            this.lowerCutSlider.setMaximum(ngrams.size() - 1);
            this.lowerCutSlider.setEnabled(true);
            this.upperCutSlider.setMaximum(ngrams.size() - 1);
            this.upperCutSlider.setEnabled(true);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }
}

