/*
 * Decompiled with CFR 0.152.
 */
package simpletree.topic;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public abstract class StopwordsList
implements Serializable {
    protected String name = "stopwords list";
    protected ArrayList<String> stopwords = new ArrayList();
    protected static final long serialVersionUID = 27L;

    public abstract void fill() throws IOException;

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<String> getStopwords() {
        return this.stopwords;
    }

    public void refresh() throws IOException {
        this.fill();
    }

    public void addStopwords(ArrayList<String> stopwords) {
        for (String stopword : stopwords) {
            if (this.stopwords.contains(stopword.toLowerCase())) continue;
            this.stopwords.add(stopword.toLowerCase());
        }
        Collections.sort(this.stopwords);
    }

    public void removeStopword(String stopword) {
        this.stopwords.remove(stopword);
    }

    public boolean isStopword(String word) {
        return Collections.binarySearch(this.stopwords, word) >= 0;
    }

    public void save(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write(this.name);
            out.write("\r\n");
            for (String stp : this.stopwords) {
                out.write(stp);
                out.write("\r\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems saving \"" + filename + "\" file!");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public String toString() {
        return this.name;
    }
}

