/*
 * Decompiled with CFR 0.152.
 */
package simpletree.topic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jclusteroutline.Outline;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.topic.Term;

public class TopicOutline
extends Outline {
    private Group labelsGroup;
    public Map<String, Float> terms = new HashMap<String, Float>();
    public float labelsOpacity;
    public float polygonOpacity;
    public Color polygonColor = Color.GREEN;

    public void placeLabels() {
        if (this.terms.isEmpty()) {
            return;
        }
        this.labelsGroup = new Group(null);
        ArrayList<Term> termList = new ArrayList<Term>();
        for (Map.Entry<String, Float> term : this.terms.entrySet()) {
            termList.add(new Term(term.getKey(), term.getValue().floatValue()));
        }
        this.labelsGroup.setTerms(termList);
        this.labelsGroup.setPolygon(this.getPolygon());
        this.labelsGroup.fillPolygon();
    }

    public void draw(Graphics2D g2) {
        g2.setComposite(AlphaComposite.getInstance(3, this.polygonOpacity));
        g2.setColor(Color.WHITE);
        g2.fillPolygon(this.getPolygon());
        g2.setComposite(AlphaComposite.getInstance(3, this.polygonOpacity));
        g2.setColor(this.polygonColor);
        g2.fillPolygon(this.getPolygon());
        if (this.terms.isEmpty()) {
            return;
        }
        g2.setComposite(AlphaComposite.getInstance(3, this.labelsOpacity));
        this.labelsGroup.draw(g2, true);
    }
}

