/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class ConnectedGraphGenerator {
    public void execute(Pair[][] neighborhood, AbstractMatrix matrix, AbstractDissimilarity diss) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < neighborhood.length; ++i) {
            for (int j = 0; j < neighborhood[i].length; ++j) {
                boolean contain = false;
                for (int k = 0; k < neighborhood[neighborhood[i][j].index].length; ++k) {
                    if (neighborhood[neighborhood[i][j].index][k].index != i) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                Pair[] newneighbors = new Pair[neighborhood[neighborhood[i][j].index].length + 1];
                for (int k = 0; k < newneighbors.length - 1; ++k) {
                    newneighbors[k] = neighborhood[neighborhood[i][j].index][k];
                }
                newneighbors[newneighbors.length - 1] = new Pair(i, neighborhood[i][j].value);
                neighborhood[neighborhood[i][j].index] = newneighbors;
            }
        }
        int nrcomponents = 0;
        HashSet<Integer> visited = new HashSet<Integer>();
        while (visited.size() < neighborhood.length) {
            int seed = 0;
            for (int i = 0; i < neighborhood.length; ++i) {
                if (visited.contains(i)) continue;
                seed = i;
                break;
            }
            if (visited.size() > 0) {
                Integer node = (Integer)visited.iterator().next();
                float dist = diss.calculate(matrix.getRow(node), matrix.getRow(seed));
                Pair[] newNeighbors1 = new Pair[neighborhood[node].length + 1];
                for (int j = 0; j < neighborhood[node].length; ++j) {
                    newNeighbors1[j] = neighborhood[node][j];
                }
                newNeighbors1[neighborhood[node.intValue()].length] = new Pair(seed, dist);
                neighborhood[node.intValue()] = newNeighbors1;
                Pair[] newNeighbors2 = new Pair[neighborhood[seed].length + 1];
                for (int j = 0; j < neighborhood[seed].length; ++j) {
                    newNeighbors2[j] = neighborhood[seed][j];
                }
                newNeighbors2[neighborhood[seed].length] = new Pair(node, dist);
                neighborhood[seed] = newNeighbors2;
            }
            this.getComponent(neighborhood, visited, seed);
            ++nrcomponents;
        }
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Number of components on the NNG: " + nrcomponents);
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Connecting components time: " + (float)(finish - start) / 1000.0f + "s");
    }

    private void getComponent(Pair[][] neighborhood, HashSet<Integer> visited, int seed) {
        visited.add(seed);
        HashSet<Integer> tovisit = new HashSet<Integer>();
        for (int i = 0; i < neighborhood[seed].length; ++i) {
            if (visited.contains(neighborhood[seed][i].index)) continue;
            tovisit.add(neighborhood[seed][i].index);
        }
        while (tovisit.size() > 0) {
            Integer[] nodes = tovisit.toArray(new Integer[0]);
            for (int i = 0; i < nodes.length; ++i) {
                tovisit.remove(nodes[i]);
                visited.add(nodes[i]);
                for (int j = 0; j < neighborhood[nodes[i]].length; ++j) {
                    if (visited.contains(neighborhood[nodes[i].intValue()][j].index)) continue;
                    tovisit.add(neighborhood[nodes[i].intValue()][j].index);
                }
            }
        }
    }
}

