/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.awt.Image;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class ImageCollection {
    private String filename;
    private Vector<String> imageUrls;

    public ImageCollection(String filename) {
        this.filename = filename;
        this.extractImageUrls();
    }

    public Image getImage(String url) throws IOException {
        ZipFile zip = new ZipFile(this.filename);
        ZipEntry entry = zip.getEntry(url.trim());
        if (entry != null) {
            InputStream is = zip.getInputStream(entry);
            return ImageIO.read(is);
        }
        return null;
    }

    public Vector<String> getImageUrls() {
        return this.imageUrls;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String f) {
        this.filename = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractImageUrls() {
        if (this.filename != null) {
            this.imageUrls = new Vector();
            ZipFile zip = null;
            try {
                Vector<String> filenames_aux = new Vector<String>();
                zip = new ZipFile(this.filename);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry2;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                    filenames_aux.add(entry2.getName().trim());
                }
                ArrayList<Integer> index_aux = new ArrayList<Integer>();
                for (int i = 0; i < filenames_aux.size(); ++i) {
                    index_aux.add(i);
                }
                int[] index = new int[filenames_aux.size()];
                int i = 0;
                for (int j = 0; j < index.length; ++j) {
                    int ind = (int)Math.pow(2.0, i);
                    if (ind >= index_aux.size()) {
                        ind = 0;
                    }
                    index[j] = (Integer)index_aux.get(ind);
                    index_aux.remove(ind);
                    ++i;
                }
                for (i = 0; i < filenames_aux.size(); ++i) {
                    this.imageUrls.add((String)filenames_aux.elementAt(index[i]));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

