/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class MeshGenerator {
    public Pair[][] execute(Pair[][] neighbors, DistanceMatrix dmat) {
        long start = System.currentTimeMillis();
        HashSet<Integer> visited = new HashSet<Integer>();
        HashSet<Integer> tovisit = new HashSet<Integer>();
        HashSet<Integer> notvisited = new HashSet<Integer>();
        tovisit.add(0);
        for (int i = 1; i < neighbors.length; ++i) {
            notvisited.add(i);
        }
        while (notvisited.size() > 0) {
            int next;
            if (tovisit.size() > 0) {
                next = (Integer)tovisit.iterator().next();
                visited.add(next);
                tovisit.remove(new Integer(next));
                notvisited.remove(new Integer(next));
                for (int i = 0; i < neighbors[next].length; ++i) {
                    if (visited.contains(neighbors[next][i].index)) continue;
                    tovisit.add(neighbors[next][i].index);
                }
                continue;
            }
            next = (Integer)notvisited.iterator().next();
            notvisited.remove(new Integer(next));
            tovisit.add(next);
            Iterator visited_it = visited.iterator();
            int closest = 0;
            float min = Float.MAX_VALUE;
            while (visited_it.hasNext()) {
                int aux = (Integer)visited_it.next();
                float distance = dmat.getDistance(aux, next);
                if (!(min > distance)) continue;
                min = distance;
                closest = aux;
            }
            Pair[] newNeighbors1 = new Pair[neighbors[next].length + 1];
            for (int i = 0; i < neighbors[next].length; ++i) {
                newNeighbors1[i] = neighbors[next][i];
            }
            newNeighbors1[neighbors[next].length] = new Pair(closest, min);
            neighbors[next] = newNeighbors1;
            Pair[] newNeighbors2 = new Pair[neighbors[closest].length + 1];
            for (int i = 0; i < neighbors[closest].length; ++i) {
                newNeighbors2[i] = neighbors[closest][i];
            }
            newNeighbors2[neighbors[closest].length] = new Pair(next, min);
            neighbors[closest] = newNeighbors2;
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Creating the mesh time: " + (float)(finish - start) / 1000.0f + "s");
        return neighbors;
    }

    public Pair[][] execute(Pair[][] neighbors, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        long start = System.currentTimeMillis();
        TreeSet<Integer> visited = new TreeSet<Integer>();
        TreeSet<Integer> tovisit = new TreeSet<Integer>();
        TreeSet<Integer> notvisited = new TreeSet<Integer>();
        tovisit.add(0);
        for (int i = 1; i < neighbors.length; ++i) {
            notvisited.add(i);
        }
        while (notvisited.size() > 0) {
            int next;
            if (tovisit.size() > 0) {
                next = (Integer)tovisit.first();
                visited.add(next);
                tovisit.remove(new Integer(next));
                notvisited.remove(new Integer(next));
                for (int i = 0; i < neighbors[next].length; ++i) {
                    if (visited.contains(neighbors[next][i].index)) continue;
                    tovisit.add(neighbors[next][i].index);
                }
                continue;
            }
            next = (Integer)notvisited.first();
            notvisited.remove(new Integer(next));
            tovisit.add(next);
            Iterator visited_it = visited.iterator();
            int closest = 0;
            float min = Float.MAX_VALUE;
            while (visited_it.hasNext()) {
                int aux = (Integer)visited_it.next();
                float distance = diss.calculate(matrix.getRow(aux), matrix.getRow(next));
                if (!(min > distance)) continue;
                min = distance;
                closest = aux;
            }
            Pair[] newNeighbors1 = new Pair[neighbors[next].length + 1];
            for (int i = 0; i < neighbors[next].length; ++i) {
                newNeighbors1[i] = neighbors[next][i];
            }
            newNeighbors1[neighbors[next].length] = new Pair(closest, min);
            neighbors[next] = newNeighbors1;
            Pair[] newNeighbors2 = new Pair[neighbors[closest].length + 1];
            for (int i = 0; i < neighbors[closest].length; ++i) {
                newNeighbors2[i] = neighbors[closest][i];
            }
            newNeighbors2[neighbors[closest].length] = new Pair(next, min);
            neighbors[closest] = newNeighbors2;
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Creating the mesh time: " + (float)(finish - start) / 1000.0f + "s");
        return neighbors;
    }
}

