/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesManager {
    private Properties properties;
    private final String filename;
    public static final String vispipUserDir = System.getProperty("user.home") + File.separator + ".VisPipeline";

    private PropertiesManager(String filename) throws IOException {
        this.filename = filename;
        File file = new File(filename);
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                this.properties = new Properties();
                this.properties.load(fis);
            }
            catch (IOException ex) {
                Logger.getLogger(PropertiesManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.properties = new Properties();
        }
    }

    public static PropertiesManager getInstance(String filename) throws IOException {
        File userDirFile = new File(vispipUserDir);
        if (!userDirFile.exists()) {
            userDirFile.mkdirs();
        }
        filename = vispipUserDir + File.separator + filename;
        return new PropertiesManager(filename);
    }

    public String getProperty(String id) {
        if (this.properties == null) {
            return "";
        }
        if (this.properties.containsKey(id)) {
            return this.properties.getProperty(id);
        }
        return "";
    }

    public void setProperty(String id, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(id, value);
        try (FileOutputStream out = new FileOutputStream(new File(this.filename));){
            this.properties.store(out, "Recording the properties...");
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(PropertiesManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

