/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.io.scalar.TreeScalar;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.util.MatrixUtils;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.LabelContent;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.corpus.folder.FolderCorpus;
import simpletree.textprocessing.processing.view.TextOpenDialog;
import simpletree.util.ProjectionUtil;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.Util;
import simpletree.util.filter.AbstractFilter;
import simpletree.util.filter.ZIPFilter;
import simpletree.view.SimpleTreeFrame;

public class SimpleTreeUtil
extends ProjectionUtil {
    public static int maxNodeId = 0;
    public static HashMap<Integer, TreeCluster> memoryTreeClusters = new HashMap();

    public static List<Double> getPolygonMainAngles(Polygon pol) {
        float[][] pointsMatrix = new float[pol.npoints][2];
        for (int i = 0; i < pol.npoints; ++i) {
            pointsMatrix[i][0] = pol.xpoints[i];
            pointsMatrix[i][1] = pol.ypoints[i];
        }
        double[][] covMatrixAux = SimpleTreeUtil.createCovarianceMatrix(pointsMatrix);
        DenseDoubleMatrix2D covmatrix = new DenseDoubleMatrix2D(covMatrixAux);
        EigenvalueDecomposition dec = new EigenvalueDecomposition((DoubleMatrix2D)covmatrix);
        DoubleMatrix2D decomp = dec.getV();
        float[] eigenvalues = new float[covMatrixAux.length];
        DoubleMatrix1D eigenvalues_aux = dec.getRealEigenvalues();
        for (int i = 0; i < covMatrixAux.length; ++i) {
            eigenvalues[i] = (float)eigenvalues_aux.get(covMatrixAux.length - i - 1);
        }
        ArrayList<Double> mainAngles = new ArrayList<Double>();
        for (int i = 0; i <= 1; ++i) {
            double dot;
            float x2;
            float y1;
            float y2;
            float x1 = (float)decomp.getQuick(i, 0);
            double det = x1 * (y2 = 0.0f) - (y1 = (float)decomp.getQuick(i, 1)) * (x2 = 1.0f);
            double theta = 57.29577791868205 * Math.atan2(det, dot = (double)(x1 * x2 + y1 * y2));
            if (theta < 0.0) {
                theta += 360.0;
            }
            if (90.0 < theta && theta <= 180.0) {
                theta = 90.0 - theta;
            } else if (180.0 < theta && theta <= 270.0) {
                theta = 270.0 - theta;
            }
            mainAngles.add(theta);
        }
        return mainAngles;
    }

    private static double[][] createCovarianceMatrix(float[][] points) {
        int i;
        int j;
        int i2;
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                int n = j;
                mean[n] = mean[n] + (double)points[i2][j];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)points.length;
        }
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                float[] fArray = points[i2];
                int n = j;
                fArray[n] = (float)((double)fArray[n] - mean[j]);
            }
        }
        double[][] covmatrix = new double[points[0].length][];
        for (i = 0; i < covmatrix.length; ++i) {
            covmatrix[i] = new double[points[0].length];
        }
        for (i = 0; i < covmatrix.length; ++i) {
            for (int j2 = 0; j2 < covmatrix.length; ++j2) {
                covmatrix[i][j2] = SimpleTreeUtil.covariance(points, i, j2);
            }
        }
        return covmatrix;
    }

    private static float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)(points.length - 1);
    }

    public static Map<Integer, Float> distanceToNodes(SimpleTreeModel stModel, int instanceId) {
        HashMap<Integer, Float> distancesMap = new HashMap<Integer, Float>();
        Stack<Integer> instancesToVisit = new Stack<Integer>();
        HashSet<Integer> instancesVisited = new HashSet<Integer>();
        instancesToVisit.add(instanceId);
        Connectivity conn = stModel.getConnectivityByName("Neighbor-Joinning");
        distancesMap.put(instanceId, Float.valueOf(0.0f));
        while (!instancesToVisit.empty()) {
            int currentInstance = (Integer)instancesToVisit.pop();
            instancesVisited.add(currentInstance);
            for (Edge e : conn.getEdges()) {
                if (e.getTarget() == currentInstance && !instancesVisited.contains(e.getSource())) {
                    instancesToVisit.add(e.getSource());
                    distancesMap.put(e.getSource(), Float.valueOf(e.getWeight() + ((Float)distancesMap.get(currentInstance)).floatValue()));
                    continue;
                }
                if (e.getSource() != currentInstance || instancesVisited.contains(e.getTarget())) continue;
                instancesToVisit.add(e.getTarget());
                distancesMap.put(e.getTarget(), Float.valueOf(e.getWeight() + ((Float)distancesMap.get(currentInstance)).floatValue()));
            }
        }
        return distancesMap;
    }

    public static List<String> getDocumentsFromInstances(SimpleTreeModel stModel, ArrayList<AbstractInstance> instances) {
        Corpus corpus = stModel.getCorpus();
        try {
            if (corpus == null) {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                corpus = TextOpenDialog.openCorpus(spm, new ZIPFilter(), null);
                if (corpus instanceof FolderCorpus) {
                    ((FolderCorpus)corpus).setLabels((LabelContent)stModel.getContent(AbstractContent.Type.LABEL));
                }
                stModel.setCorpus(corpus);
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < instances.size(); ++i) {
                AbstractInstance inst = instances.get(i);
                if (inst instanceof ClusterSimpleTreeInstance) {
                    TreeCluster treeCluster;
                    Cluster cluster = ((ClusterSimpleTreeInstance)inst).getCluster();
                    if (cluster != null) {
                        ArrayList<Integer> newIds = new ArrayList<Integer>();
                        if (!cluster.getMedoidList().isEmpty()) {
                            newIds.addAll(cluster.getMedoidList());
                        } else {
                            newIds.addAll(cluster.getItemList());
                        }
                        LabelContent labels = (LabelContent)stModel.getContent(AbstractContent.Type.LABEL);
                        Iterator iterator = newIds.iterator();
                        while (iterator.hasNext()) {
                            int id = (Integer)iterator.next();
                            if (!(corpus instanceof FolderCorpus)) {
                                String label = labels.get(id);
                                int hashId = Util.convertToInt(label);
                                ids.add(hashId);
                                continue;
                            }
                            ids.add(id);
                        }
                    }
                    if ((treeCluster = ((ClusterSimpleTreeInstance)inst).getTreeCluster()) == null) continue;
                    SupertreeFile stFile = stModel.getSupertreeFile();
                    ArrayList<Integer> newIds = new ArrayList<Integer>();
                    if (treeCluster.getMedoidList().size() == 1 && treeCluster.getSize() > 1) {
                        TreeCluster loadedCluster = stFile.Cluster.load(treeCluster.getId());
                        ((ClusterSimpleTreeInstance)inst).setTreeCluster(loadedCluster);
                        treeCluster = loadedCluster;
                        if (stModel.getContent(AbstractContent.Type.LABEL) != null) {
                            LabelContent labelContent = (LabelContent)stModel.getContent(AbstractContent.Type.LABEL);
                            Map<Integer, String> labelsMap = labelContent.getMap();
                            List<String> allLabels = stFile.Label.getLabels();
                            for (int medoidId : treeCluster.getMedoidList()) {
                                labelsMap.put(medoidId, allLabels.get(medoidId));
                            }
                            if (corpus instanceof FolderCorpus) {
                                ((FolderCorpus)corpus).setLabels(labelContent);
                            }
                        }
                    }
                    if (!treeCluster.getMedoidList().isEmpty()) {
                        newIds.addAll(treeCluster.getMedoidList());
                    } else {
                        newIds.addAll(treeCluster.getItemList());
                    }
                    Iterator iterator = newIds.iterator();
                    while (iterator.hasNext()) {
                        int newId = (Integer)iterator.next();
                        if (!(corpus instanceof FolderCorpus)) {
                            String label = stFile.Label.getById(newId);
                            int hashId = Util.convertToInt(label);
                            ids.add(hashId);
                            continue;
                        }
                        ids.add(newId);
                    }
                    continue;
                }
                SupertreeFile stFile = stModel.getSupertreeFile();
                if (stFile != null && !(corpus instanceof FolderCorpus)) {
                    String label = stFile.Label.getById(inst.getId());
                    ids.add(Util.convertToInt(label));
                    continue;
                }
                ids.add(inst.getId());
            }
            ArrayList<String> docs = new ArrayList<String>();
            for (int i = 0; i < ids.size(); ++i) {
                int id = (Integer)ids.get(i);
                String doc = corpus.getFullContent(id);
                docs.add(doc);
            }
            return docs;
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static List<Integer> getMedoidList(SimpleTree simpleTree, AbstractMatrix matrix) {
        ArrayList<Integer> medoidList = new ArrayList<Integer>();
        for (ContentSimpleTree node : simpleTree.getNodes()) {
            AbstractVector matrixRow = MatrixUtils.getRowById(node.getId(), matrix);
            if (matrixRow == null) continue;
            int matrixRowIndex = matrix.getRows().indexOf(matrixRow);
            medoidList.add(matrixRowIndex);
        }
        return medoidList;
    }

    public static void importScalars(SimpleTreeModel model, String filename) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            ArrayList<String> scalars = new ArrayList<String>();
            int linenumber = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++linenumber;
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    scalars.add(t.nextToken().trim());
                }
                break block9;
            }
            int indexScalar = 1;
            for (int i = 0; i < scalars.size(); ++i) {
                if (model.getScalarByName((String)scalars.get(i)) != null) {
                    if (((String)scalars.get(i)).equalsIgnoreCase("...")) continue;
                    while (model.getScalarByName((String)scalars.get(i) + "_" + indexScalar) != null) {
                        ++indexScalar;
                    }
                    model.addScalar((String)scalars.get(i) + "_" + indexScalar);
                    scalars.set(i, (String)scalars.get(i) + "_" + indexScalar);
                    continue;
                }
                model.addScalar((String)scalars.get(i));
            }
            int instancesProcessed = 0;
            while ((line = in.readLine()) != null) {
                ++linenumber;
                ArrayList<Float> values = new ArrayList<Float>();
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";", false);
                String fname = t.nextToken().trim();
                while (t.hasMoreTokens()) {
                    float value = Float.parseFloat(t.nextToken().trim());
                    values.add(Float.valueOf(value));
                }
                if (scalars.size() != values.size()) {
                    throw new IOException("The number of values for one scalar does not match with the number of declared scalars.\r\nCheck line " + linenumber + " of the file.");
                }
                int id = Util.isParsableToInt(fname) ? Integer.parseInt(fname) : Util.convertToInt(fname);
                SimpleTreeInstance pi = model.getInstanceById(id);
                if (pi == null) continue;
                for (int i = 0; i < scalars.size(); ++i) {
                    if (model.getScalarByName((String)scalars.get(i)) == null) continue;
                    pi.setScalarValue(model.getScalarByName((String)scalars.get(i)), ((Float)values.get(i)).floatValue());
                }
                if (++instancesProcessed < model.getValidInstances().size()) continue;
                break;
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void convertToSuperTree(SimpleTree tree, TreeCluster cluster, SupertreeFile stFile) throws IOException {
        for (TreeCluster lightSubCluster : cluster.getSubClusterList()) {
            ClusterContentSimpleTree clusterNode;
            ContentSimpleTree treeNode = tree.getNodeById(lightSubCluster.getId());
            int treeNodePosition = tree.getNodePosition(treeNode);
            TreeCluster subCluster = stFile.Cluster.load(lightSubCluster.getId());
            if (subCluster == null) {
                subCluster = memoryTreeClusters.get(lightSubCluster.getId());
                clusterNode = new ClusterContentSimpleTree(lightSubCluster.getId(), subCluster);
                clusterNode.manuallyCreated = true;
            } else {
                clusterNode = new ClusterContentSimpleTree(lightSubCluster.getId(), subCluster);
            }
            clusterNode.setParent(treeNode.getParent());
            List<Integer> medoids = subCluster.getMedoidList();
            clusterNode.setKlass(stFile.Scalar.getById(medoids.get(0)));
            clusterNode.setLevel(treeNode.getLevel());
            clusterNode.setValid(treeNode.isValid());
            clusterNode.setRecursiveChildCount(subCluster.getSize());
            clusterNode.setLevelHeight(subCluster.getLevelHeight());
            tree.removeNode(treeNode);
            tree.insertNodeAt(treeNodePosition, clusterNode);
        }
        for (ContentSimpleTree treeNode : tree.getNodes()) {
            if (!treeNode.isValid() || treeNode instanceof ClusterContentSimpleTree) continue;
            treeNode.setKlass(stFile.Scalar.getById(treeNode.getId()));
        }
    }

    public static void convertToSuperTree(SimpleTree tree, TreeCluster cluster, int levels, int minClusterSize, SupertreeFile stFile) throws IOException {
        for (TreeCluster lightSubCluster : cluster.getSubClusterList()) {
            ContentSimpleTree treeNode = tree.getNodeById(lightSubCluster.getId());
            int treeNodePosition = tree.getNodePosition(treeNode);
            if (levels > 1 || lightSubCluster.getSize() <= minClusterSize) {
                if (lightSubCluster.getSize() == 0) {
                    System.err.println("Error! Zero-sized sub-cluster " + lightSubCluster.getId());
                    continue;
                }
                TreeCluster subCluster = stFile.Cluster.load(lightSubCluster.getId());
                String subClusterNewick = subCluster.getNewick();
                SimpleTree subClusterTree = new SimpleTree(subClusterNewick);
                SimpleTreeUtil.convertToSuperTree(subClusterTree, subCluster, levels - 1, minClusterSize, stFile);
                tree.appendTree(subClusterTree, treeNode.getId(), false);
                continue;
            }
            TreeCluster fullNodeCluster = stFile.Cluster.load(lightSubCluster.getId());
            ClusterContentSimpleTree clusterNode = new ClusterContentSimpleTree(lightSubCluster.getId(), fullNodeCluster);
            List<Integer> medoids = lightSubCluster.getMedoidList();
            clusterNode.setParent(treeNode.getParent());
            clusterNode.setKlass(stFile.Scalar.getById(medoids.get(0)));
            clusterNode.setLevel(treeNode.getLevel());
            clusterNode.setValid(treeNode.isValid());
            clusterNode.setRecursiveChildCount(lightSubCluster.getSize());
            clusterNode.setLevelHeight(lightSubCluster.getLevelHeight());
            tree.removeNode(treeNode);
            tree.insertNodeAt(treeNodePosition, clusterNode);
        }
    }

    public static void convertToSuperTree(SimpleTree tree, TreeCluster cluster, int levels, int minClusterSize, TreeScalar treeScalars) throws IOException {
        for (TreeCluster subCluster : cluster.getSubClusterList()) {
            ContentSimpleTree treeNode = tree.getNodeById(subCluster.getId());
            int treeNodePosition = tree.getNodePosition(treeNode);
            if (levels > 1 || subCluster.getSize() <= minClusterSize) {
                if (subCluster.getSize() == 0) {
                    System.err.println("Error! Zero-sized sub-cluster " + subCluster.getId());
                    continue;
                }
                String subClusterNewick = subCluster.getNewick();
                SimpleTree subClusterTree = new SimpleTree(subClusterNewick);
                SimpleTreeUtil.convertToSuperTree(subClusterTree, subCluster, levels - 1, minClusterSize, treeScalars);
                tree.appendTree(subClusterTree, treeNode.getId(), false);
                continue;
            }
            ClusterContentSimpleTree clusterNode = new ClusterContentSimpleTree(subCluster.getId(), subCluster);
            clusterNode.setParent(treeNode.getParent());
            List<Integer> medoids = subCluster.getMedoidList();
            clusterNode.setKlass(treeScalars.get(medoids.get(0)));
            clusterNode.setLevel(treeNode.getLevel());
            clusterNode.setValid(treeNode.isValid());
            clusterNode.setRecursiveChildCount(subCluster.getSize());
            clusterNode.setLevelHeight(subCluster.getLevelHeight());
            tree.removeNode(treeNode);
            tree.insertNodeAt(treeNodePosition, clusterNode);
        }
    }

    public static void exportScalars(SimpleTreeModel model, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < model.getScalars().size(); ++i) {
                out.write(model.getScalars().get(i).getName().replaceAll(";", "_"));
                if (i >= model.getScalars().size() - 1) continue;
                out.write(";");
            }
            out.write("\r\n");
            for (AbstractInstance pi : model.getValidInstances()) {
                if (model.getLabels() != null && !model.getLabels().isEmpty() && model.getLabels().containsKey(pi.getId())) {
                    out.write(model.getLabels().get(pi.getId()) + ";");
                } else {
                    out.write(pi.getId() + ";");
                }
                for (int i = 0; i < model.getScalars().size(); ++i) {
                    float scalar = ((SimpleTreeInstance)pi).getScalarValue(model.getScalars().get(i));
                    out.write(Float.toString(scalar).replaceAll(";", "_"));
                    if (i >= model.getScalars().size() - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static Rectangle TransformRectangle(Shape rectangle, float aspectRatio) {
        Rectangle boundingRectangle = (Rectangle)rectangle.getBounds().clone();
        float newHeight = boundingRectangle.height;
        float newWidth = boundingRectangle.width;
        if (boundingRectangle.width > boundingRectangle.height) {
            newWidth = boundingRectangle.width;
            newHeight = (float)boundingRectangle.width / aspectRatio;
        } else if (boundingRectangle.width < boundingRectangle.height) {
            newHeight = boundingRectangle.height;
            newWidth = (float)boundingRectangle.height * aspectRatio;
        }
        boundingRectangle.setSize((int)newWidth, (int)newHeight);
        return boundingRectangle;
    }

    public void saveMatrix(SimpleTreeFrame frame, AbstractMatrix mat) {
        try {
            PropertiesManager spm;
            int result;
            if (mat == null || mat.getRowCount() == 0) {
                System.err.println("simpletree.util.SimpleTreeUtil->saveMatrix(): ERROR{<matrix> is empty or not instantiated}");
                System.exit(0);
            }
            if ((result = SaveDialog.showSaveDialog(spm = PropertiesManager.getInstance("graph.properties"), new DataFilter(), frame, "filename.data")) == 0) {
                String filename = SaveDialog.getFilename();
                mat.save(filename);
                System.out.println("[SAVED]: " + filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveSelectedInstancesToMatrix(SimpleTreeFrame frame, ArrayList<SimpleTreeInstance> instances, AbstractMatrix originalmatrix) {
        AbstractMatrix nMatrix = null;
        try {
            nMatrix = MatrixFactory.getInstance(originalmatrix.getClass());
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (SimpleTreeInstance in : instances) {
            int id = in instanceof ClusterSimpleTreeInstance ? ((ClusterSimpleTreeInstance)in).getCluster().getMedoidList().get(0).intValue() : in.getId();
            int pos = originalmatrix.getIds().indexOf(id);
            AbstractVector vet = originalmatrix.getRow(pos);
            nMatrix.addRow(vet);
        }
        this.saveMatrix(frame, nMatrix);
    }

    private class DataFilter
    extends AbstractFilter {
        private DataFilter() {
        }

        @Override
        public String getDescription() {
            return "Data Points File (*.data)";
        }

        @Override
        public String getProperty() {
            return "DATA.DIR";
        }

        @Override
        public String getFileExtension() {
            return "data";
        }
    }
}

