/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import simpletree.util.PseudoClass;

public class TablePScalar
extends AbstractTableModel {
    List list;
    Vector rows = new Vector();
    Vector columns = new Vector();
    Class[] columnType;
    TablePScalar pcs;

    public TablePScalar(List ls, TablePScalar ps) throws Exception {
        this.list = ls;
        this.pcs = ps;
        Class[] head = new Class[]{String.class, String.class, Boolean.class, Float.class, Integer.class};
        this.columnType = head;
        this.columns.add("File Name");
        this.columns.add("PseudoClass Name");
        this.columns.add("+");
        this.columns.add("Color");
        this.columns.add("ID");
        this.fill();
    }

    public void addFila(PseudoClass detalle) {
        Vector<Object> row = new Vector<Object>();
        block7: for (int i = 0; i < this.columns.size(); ++i) {
            switch (i) {
                case 4: {
                    row.add(detalle.id);
                    continue block7;
                }
                case 0: {
                    row.add(detalle.originalFile);
                    continue block7;
                }
                case 1: {
                    row.add(detalle.oldClass);
                    continue block7;
                }
                case 2: {
                    row.add(detalle.option);
                    continue block7;
                }
                case 3: {
                    Float color = Float.valueOf(this.getColor(detalle.oldClass, this.rows.size() + 1));
                    row.add(color);
                    continue block7;
                }
            }
        }
        this.rows.add(row);
        this.fireTableRowsInserted(this.rows.size(), this.rows.size());
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int c) {
        return (String)this.columns.elementAt(c);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Vector v = (Vector)this.rows.elementAt(row);
        return v.elementAt(col);
    }

    public Class getColumnClass(int c) {
        return this.columnType[c];
    }

    public Float getMaxColor() {
        Float color = new Float(0.0f);
        for (int i = 0; i < this.rows.size(); ++i) {
            Float f = Float.valueOf(Float.valueOf(this.getValueAt(i, 3).toString().trim()).floatValue());
            if (!(f.floatValue() > color.floatValue())) continue;
            color = f;
        }
        return color;
    }

    @Override
    public void setValueAt(Object valor, int row, int col) {
        Vector v = (Vector)this.rows.elementAt(row);
        v.set(col, valor);
        if (col == 1 && this.pcs != null) {
            Float color = Float.valueOf(this.getColor((String)valor, row));
            v.set(3, color);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    private float getColor(String clase, int fila) {
        int j;
        Float color = new Float(0.0f);
        int i = this.pcs.getNumRowGiveClass(clase, fila);
        color = i >= 0 ? Float.valueOf(Float.valueOf(this.pcs.getValueAt(i, 3).toString().trim()).floatValue()) : ((j = this.getNumRowGiveClass(clase, fila)) >= 0 && j != fila ? Float.valueOf(Float.valueOf(this.getValueAt(j, 3).toString().trim()).floatValue()) : Float.valueOf(this.pcs.getMaxColor().floatValue() + 1.0f));
        return color.floatValue();
    }

    public int getNumRowGiveId(int id) {
        int r = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            int valor = (Integer)this.getValueAt(i, 4);
            if (id != valor) continue;
            r = i;
            break;
        }
        return r;
    }

    public int getNumRowGiveName(String object) {
        int r = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            String valor = (String)this.getValueAt(i, 0);
            if (!object.equals(valor)) continue;
            r = i;
            break;
        }
        return r;
    }

    private int getNumRowGiveClass(String object, int fila) {
        int r = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            String valor = (String)this.getValueAt(i, 1);
            if (!object.equals(valor) || i == fila) continue;
            r = i;
            break;
        }
        return r;
    }

    public void writeTablePS(String path) {
        File fileC = new File(path);
        int longitud = this.rows.size();
        try {
            FileWriter fstream = new FileWriter(fileC.getAbsolutePath());
            BufferedWriter out = new BufferedWriter(fstream);
            String rowdata = "'cdata'\n";
            out.write(rowdata);
            for (int i = 0; i < longitud; ++i) {
                String filename = this.getValueAt(i, 0).toString();
                String scalar = this.getValueAt(i, 3).toString();
                rowdata = filename + ";" + scalar + "\n";
                out.write(rowdata);
            }
            out.close();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, "Could not write tablePS" + e1.getMessage(), "error", 0);
            System.out.println("Error: Could not write tablePS" + e1.getMessage());
        }
    }

    public void writeTablePS(String path, String temp) {
        File fileC = new File(path);
        File fileT = new File(temp);
        int longitud = this.rows.size();
        try {
            String rowdata;
            fileT.delete();
            boolean renameOk = fileC.renameTo(fileT);
            if (!renameOk) {
                throw new RuntimeException("Could not rename the file " + fileC.getAbsolutePath() + " to " + fileT.getAbsolutePath());
            }
            FileWriter fstream = new FileWriter(fileC);
            BufferedWriter out = new BufferedWriter(fstream);
            FileReader freader = new FileReader(fileT);
            BufferedReader in = new BufferedReader(freader);
            while ((rowdata = in.readLine()) != null) {
                out.write(rowdata);
                out.newLine();
            }
            in.close();
            for (int i = 0; i < longitud; ++i) {
                String filename = this.getValueAt(i, 0).toString();
                String scalar = this.getValueAt(i, 3).toString();
                rowdata = filename + ";" + scalar + "\n";
                out.write(rowdata);
            }
            out.close();
            fileT.delete();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, "Could not write tablePS" + e1.getMessage(), "error", 0);
            System.out.println("Error: Could not write tablePS" + e1.getMessage());
        }
    }

    public void printTablePS() {
        System.out.println("********************************************************");
        for (int i = 0; i < this.rows.size(); ++i) {
            System.out.println("filename>> " + this.getValueAt(i, 0));
            System.out.println("class>> " + this.getValueAt(i, 1));
            System.out.println("scalar>> " + this.getValueAt(i, 3));
            System.out.println("--------------------------");
        }
    }

    public void fill() {
        this.rows.clear();
        int j = 0;
        PseudoClass detalle2 = new PseudoClass();
        for (PseudoClass detalle2 : this.list) {
            Vector<Object> row = new Vector<Object>();
            ++j;
            block8: for (int i = 0; i < this.columns.size(); ++i) {
                switch (i) {
                    case 4: {
                        row.add(detalle2.id);
                        continue block8;
                    }
                    case 0: {
                        row.add(detalle2.originalFile);
                        continue block8;
                    }
                    case 1: {
                        row.add(detalle2.oldClass);
                        continue block8;
                    }
                    case 2: {
                        row.add(detalle2.option);
                        continue block8;
                    }
                    case 3: {
                        row.add(detalle2.color);
                    }
                }
            }
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size(), this.rows.size());
            this.fireTableDataChanged();
        }
    }
}

