/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MemoryCheck
extends JDialog {
    private static Checker checker;
    private static MemoryCheck instance;
    private static boolean autoCall;
    private JCheckBox autoCheckBox;
    private JPanel buttonPanel;
    private JLabel currentLabel;
    private static JTextField currentTextField;
    private JButton gcButton;
    private JLabel maximumLabel;
    private static JTextField maximumTextField;
    private JPanel memoryPanel;

    private MemoryCheck(Frame parent) {
        super(parent);
        this.initComponents();
        autoCall = false;
        checker = new Checker();
        checker.start();
    }

    private void initComponents() {
        this.memoryPanel = new JPanel();
        this.currentLabel = new JLabel();
        currentTextField = new JTextField();
        this.maximumLabel = new JLabel();
        maximumTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.gcButton = new JButton();
        this.autoCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Memory Check");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.memoryPanel.setBorder(BorderFactory.createTitledBorder("Memory Used"));
        this.memoryPanel.setLayout(new GridBagLayout());
        this.currentLabel.setText("Current");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.memoryPanel.add((Component)this.currentLabel, gridBagConstraints);
        currentTextField.setColumns(10);
        currentTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.memoryPanel.add((Component)currentTextField, gridBagConstraints);
        this.maximumLabel.setText("Maximum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.memoryPanel.add((Component)this.maximumLabel, gridBagConstraints);
        maximumTextField.setColumns(10);
        maximumTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.memoryPanel.add((Component)maximumTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.memoryPanel, "Center");
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gcButton.setText("Call Garbage Collector");
        this.gcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryCheck.this.gcButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonPanel.add((Component)this.gcButton, gridBagConstraints);
        this.autoCheckBox.setText("Automatically");
        this.autoCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryCheck.this.autoCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonPanel.add((Component)this.autoCheckBox, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void autoCheckBoxActionPerformed(ActionEvent evt) {
        autoCall = this.autoCheckBox.isSelected();
    }

    private void gcButtonActionPerformed(ActionEvent evt) {
        Runtime.getRuntime().gc();
        checker.check();
    }

    public static void showMemoryCheck() {
        if (instance == null) {
            instance = new MemoryCheck(null);
        }
        instance.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static class Checker
    extends Thread {
        private double maxMemoryUsed = Double.MIN_VALUE;

        @Override
        public void run() {
            try {
                while (true) {
                    this.check();
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }

        public void check() {
            double usedMemory;
            Runtime r = Runtime.getRuntime();
            if (autoCall) {
                r.gc();
            }
            if (this.maxMemoryUsed < (usedMemory = (double)r.totalMemory() / 1024.0 / 1024.0 - (double)r.freeMemory() / 1024.0 / 1024.0)) {
                this.maxMemoryUsed = usedMemory;
            }
            NumberFormat form = NumberFormat.getInstance();
            form.setMaximumFractionDigits(2);
            form.setMinimumFractionDigits(2);
            currentTextField.setText(form.format(usedMemory) + " MB");
            maximumTextField.setText(form.format(this.maxMemoryUsed) + " MB");
        }
    }
}

