/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import simpletree.coordination.AbstractCoordinator;
import simpletree.coordination.SimpleTreeClassMatchCoordination;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.distance.DistanceMatrix;
import simpletree.io.file.SupertreeFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.content.LabelContent;
import simpletree.textprocessing.corpus.folder.FolderCorpus;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.SimpleTreeReportView;
import simpletree.view.TreeFrameParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.View", name="Simple Tree View Frame", description="Display a simple tree model.")
public class SimpleTreeFrameComp
implements AbstractComponent {
    static boolean isHookSet = false;
    public static final long serialVersionUID = 1L;
    private String title = "";
    private transient SimpleTreeFrame parentFrame;
    private int parentClusterId = -1;
    private transient SimpleTreeModel model;
    private transient TreeFrameParamView paramview;
    private ArrayList<AbstractCoordinator> coordinators;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    private transient MultiscaleData clusterData;
    private transient SimpleTreeFrame frame;

    public void execute() throws IOException {
        if (this.model == null) {
            throw new IOException("A tree model should be provided.");
        }
        if (this.model.getSupertreeFile() != null) {
            SupertreeFile stFile = this.model.getSupertreeFile();
            if (stFile.Label.hasLabels()) {
                LabelContent labelContent = new LabelContent();
                HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
                for (AbstractInstance inst : this.model.getInstances()) {
                    if (((SimpleTreeInstance)inst).isValid() && !(inst instanceof ClusterSimpleTreeInstance)) {
                        String instanceLabel = stFile.Label.getById(inst.getId());
                        if (instanceLabel == null) continue;
                        labelMap.put(inst.getId(), instanceLabel);
                        continue;
                    }
                    if (!((SimpleTreeInstance)inst).isValid() || !(inst instanceof ClusterSimpleTreeInstance)) continue;
                    int firstMedoidId = ((ClusterSimpleTreeInstance)inst).getTreeCluster().getMedoidList().get(0);
                    String firstMedoidLabel = stFile.Label.getById(firstMedoidId);
                    if (firstMedoidLabel != null) {
                        labelMap.put(inst.getId(), firstMedoidLabel);
                    }
                    for (Integer medoidId : ((ClusterSimpleTreeInstance)inst).getTreeCluster().getMedoidList()) {
                        String medoidLabel = stFile.Label.getById(medoidId);
                        if (medoidLabel == null) continue;
                        labelMap.put(medoidId, medoidLabel);
                    }
                }
                labelContent.setMap(labelMap);
                if (!labelMap.isEmpty()) {
                    this.model.addContent(labelContent);
                }
                if (this.model.getCorpus() != null && this.model.getCorpus() instanceof FolderCorpus) {
                    FolderCorpus folderCorpus = (FolderCorpus)this.model.getCorpus();
                    if (!labelMap.isEmpty()) {
                        folderCorpus.setLabels(labelContent);
                    }
                }
            }
            Scalar cdata = this.model.getScalarByName("cdata");
            float minCdata = stFile.Scalar.getMin();
            float maxCdata = stFile.Scalar.getMax();
            cdata.setMin(minCdata);
            cdata.setMax(maxCdata);
        }
        if (this.matrix != null) {
            Scalar cdata;
            if (this.model.getMatrix() == null) {
                this.model.setMatrix(this.matrix);
            }
            if ((cdata = this.model.getScalarByName("cdata")) != null) {
                float minCdata = Float.MAX_VALUE;
                float maxCdata = Float.MIN_VALUE;
                for (float cdataValue : this.matrix.getClassData()) {
                    if (cdataValue > maxCdata) {
                        maxCdata = cdataValue;
                        continue;
                    }
                    if (!(cdataValue < minCdata)) continue;
                    minCdata = cdataValue;
                }
                cdata.setMax(maxCdata);
                cdata.setMin(minCdata);
            }
        }
        SimpleTreeFrame newFrame = new SimpleTreeFrame();
        newFrame.setClusterData(this.clusterData);
        newFrame.setSize(600, 600);
        newFrame.setDefaultCloseOperation(2);
        newFrame.setVisible(true);
        newFrame.setTitle(this.title);
        newFrame.setMatrix(this.matrix);
        newFrame.setParentFrame(this.parentFrame);
        newFrame.setModel(this.model);
        newFrame.setParentHighlightInstance(this.parentClusterId);
        if (this.parentFrame != null) {
            newFrame.setVoronoiColorAlpha(this.parentFrame.getVoronoiColorAlpha());
            newFrame.setVoronoiBackgroudAlpha(this.parentFrame.getVoronoiBackgroundAlpha());
            newFrame.setVoronoiEdgesAlpha(this.parentFrame.getVoronoiEdgesAlpha());
            SimpleTreeModel parentModel = (SimpleTreeModel)this.parentFrame.getModel();
            parentModel.setHighLightInstanceId(this.parentClusterId);
            parentModel.setChanged();
            parentModel.notifyObservers();
        }
        if (this.coordinators != null) {
            for (AbstractCoordinator coordinator : this.coordinators) {
                newFrame.addCoordinator(coordinator);
                if (!(coordinator instanceof SimpleTreeClassMatchCoordination)) continue;
                ((SimpleTreeClassMatchCoordination)coordinator).match();
            }
        }
        ((SimpleTreeReportView)newFrame.getReportPanel()).clean();
        ((SimpleTreeReportView)newFrame.getReportPanel()).setObjects(this.model.getValidInstances().size());
        ((SimpleTreeReportView)newFrame.getReportPanel()).setVirtualObjects(this.model.getInstances().size() - this.model.getValidInstances().size());
        ((SimpleTreeReportView)newFrame.getReportPanel()).setType(this.model.getType());
        this.frame = newFrame;
        if (!isHookSet) {
            isHookSet = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println("Exiting application...");
                }
            });
        }
    }

    public void input(@Param(name="Original Distance Matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public void input(@Param(name="Original Data Matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="tree model") SimpleTreeModel model) {
        this.model = model;
    }

    public void input(@Param(name="Cluster Data") MultiscaleData clusterData) {
        this.clusterData = clusterData;
    }

    public void attach(@Param(name="Coordinator") AbstractCoordinator coordinator) {
        if (this.coordinators == null) {
            this.coordinators = new ArrayList();
        }
        if (coordinator != null) {
            this.coordinators.add(coordinator);
        }
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new TreeFrameParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
        this.coordinators = null;
        this.matrix = null;
        this.dmat = null;
        this.clusterData = null;
        this.parentFrame = null;
        this.frame = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setParentFrame(SimpleTreeFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void setParentClusterId(int clusterId) {
        this.parentClusterId = clusterId;
    }

    public SimpleTreeFrame getCurrentFrame() {
        return this.frame;
    }
}

