/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.basics.color.ColorTable;
import simpletree.coordination.ConfusingMatrixDialog;
import simpletree.model.Scalar;
import simpletree.view.ClassMatchData;

public class SimpleTreeReportView
extends JPanel {
    private TreeMap<Float, HashMap<Float, Integer>> confuseData;
    private ColorTable colortable;
    private HashMap<String, ClassMatchData> matchs = new HashMap();
    private JPanel classMatchingPanel;
    private JButton confuseMatrixButton;
    private JPanel dataPanel;
    private JLabel distanceTypeLabel;
    protected JTextField distanceTypeTextField;
    private JLabel matchingLabel;
    protected JTextField matchingTextField;
    private JLabel nonCorrespondingLabel;
    protected JTextField nonCorrespondingTextField;
    private JLabel nonMatchingLabel;
    protected JTextField nonMatchingTextField;
    private JLabel numberDimensionsLabel;
    protected JTextField numberDimensionsTextField;
    private JLabel numberObjectsLabel;
    protected JTextField numberObjectsTextField;
    private JLabel numberVirtualObjectsLabel;
    private JTextField numberVirtualObjectsTextField;
    private JLabel typeLabel;
    private JTextField typeTextField;

    public SimpleTreeReportView() {
        this.initComponents();
        this.classMatchingPanel.setVisible(false);
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.numberObjectsLabel = new JLabel();
        this.numberObjectsTextField = new JTextField();
        this.numberDimensionsLabel = new JLabel();
        this.numberDimensionsTextField = new JTextField();
        this.distanceTypeLabel = new JLabel();
        this.distanceTypeTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeTextField = new JTextField();
        this.numberVirtualObjectsLabel = new JLabel();
        this.numberVirtualObjectsTextField = new JTextField();
        this.classMatchingPanel = new JPanel();
        this.matchingLabel = new JLabel();
        this.nonMatchingLabel = new JLabel();
        this.nonCorrespondingLabel = new JLabel();
        this.matchingTextField = new JTextField();
        this.nonMatchingTextField = new JTextField();
        this.nonCorrespondingTextField = new JTextField();
        this.confuseMatrixButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Tree Parameters"));
        this.setLayout(new GridBagLayout());
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.numberObjectsLabel.setHorizontalAlignment(4);
        this.numberObjectsLabel.setText("Number Objects : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberObjectsLabel, gridBagConstraints);
        this.numberObjectsTextField.setColumns(7);
        this.numberObjectsTextField.setEditable(false);
        this.numberObjectsTextField.setMinimumSize(new Dimension(26, 20));
        this.numberObjectsTextField.setPreferredSize(new Dimension(22, 20));
        this.numberObjectsTextField.setRequestFocusEnabled(false);
        this.numberObjectsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeReportView.this.numberObjectsTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberObjectsTextField, gridBagConstraints);
        this.numberDimensionsLabel.setHorizontalAlignment(4);
        this.numberDimensionsLabel.setText("Number Dimensions : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberDimensionsLabel, gridBagConstraints);
        this.numberDimensionsTextField.setColumns(7);
        this.numberDimensionsTextField.setEditable(false);
        this.numberDimensionsTextField.setMinimumSize(new Dimension(26, 20));
        this.numberDimensionsTextField.setPreferredSize(new Dimension(22, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberDimensionsTextField, gridBagConstraints);
        this.distanceTypeLabel.setHorizontalAlignment(4);
        this.distanceTypeLabel.setText("Distance Type : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.distanceTypeLabel, gridBagConstraints);
        this.distanceTypeTextField.setColumns(10);
        this.distanceTypeTextField.setEditable(false);
        this.distanceTypeTextField.setMinimumSize(new Dimension(46, 20));
        this.distanceTypeTextField.setPreferredSize(new Dimension(326, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.distanceTypeTextField, gridBagConstraints);
        this.typeLabel.setHorizontalAlignment(4);
        this.typeLabel.setText("Technique : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeTextField.setEditable(false);
        this.typeTextField.setMinimumSize(new Dimension(150, 20));
        this.typeTextField.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.typeTextField, gridBagConstraints);
        this.numberVirtualObjectsLabel.setText("Number Virtual Objects : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberVirtualObjectsLabel, gridBagConstraints);
        this.numberVirtualObjectsTextField.setColumns(7);
        this.numberVirtualObjectsTextField.setEditable(false);
        this.numberVirtualObjectsTextField.setMinimumSize(new Dimension(26, 20));
        this.numberVirtualObjectsTextField.setPreferredSize(new Dimension(22, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberVirtualObjectsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.dataPanel, gridBagConstraints);
        this.classMatchingPanel.setBorder(BorderFactory.createTitledBorder("Class Matching"));
        this.classMatchingPanel.setLayout(new GridBagLayout());
        this.matchingLabel.setHorizontalAlignment(4);
        this.matchingLabel.setText("Matching objects : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.matchingLabel, gridBagConstraints);
        this.nonMatchingLabel.setHorizontalAlignment(4);
        this.nonMatchingLabel.setText("Non-matching objects : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.nonMatchingLabel, gridBagConstraints);
        this.nonCorrespondingLabel.setHorizontalAlignment(4);
        this.nonCorrespondingLabel.setText("Non-corresponding objects : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.nonCorrespondingLabel, gridBagConstraints);
        this.matchingTextField.setColumns(7);
        this.matchingTextField.setEditable(false);
        this.matchingTextField.setMinimumSize(new Dimension(26, 20));
        this.matchingTextField.setPreferredSize(new Dimension(22, 20));
        this.matchingTextField.setRequestFocusEnabled(false);
        this.matchingTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeReportView.this.matchingTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.matchingTextField, gridBagConstraints);
        this.nonMatchingTextField.setColumns(7);
        this.nonMatchingTextField.setEditable(false);
        this.nonMatchingTextField.setMinimumSize(new Dimension(26, 20));
        this.nonMatchingTextField.setPreferredSize(new Dimension(22, 20));
        this.nonMatchingTextField.setRequestFocusEnabled(false);
        this.nonMatchingTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeReportView.this.nonMatchingTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.nonMatchingTextField, gridBagConstraints);
        this.nonCorrespondingTextField.setColumns(7);
        this.nonCorrespondingTextField.setEditable(false);
        this.nonCorrespondingTextField.setMinimumSize(new Dimension(26, 20));
        this.nonCorrespondingTextField.setPreferredSize(new Dimension(22, 20));
        this.nonCorrespondingTextField.setRequestFocusEnabled(false);
        this.nonCorrespondingTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeReportView.this.nonCorrespondingTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classMatchingPanel.add((Component)this.nonCorrespondingTextField, gridBagConstraints);
        this.confuseMatrixButton.setText("Confusion Matrix");
        this.confuseMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeReportView.this.confuseMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.classMatchingPanel.add((Component)this.confuseMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.classMatchingPanel, gridBagConstraints);
    }

    private void numberObjectsTextFieldActionPerformed(ActionEvent evt) {
    }

    private void matchingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void nonMatchingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void nonCorrespondingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void confuseMatrixButtonActionPerformed(ActionEvent evt) {
        String str = JOptionPane.showInputDialog(null, "Inform a label for the Confusion Matrix (Optional)", "Confusion Matrix Label", 1);
        if (str != null) {
            ConfusingMatrixDialog.getInstance(null).display(this.confuseData, this.colortable, str);
        }
    }

    public void setType(String type) {
        this.typeTextField.setText(type);
    }

    public void setDimensions(int dim) {
        if (dim != 0) {
            this.numberDimensionsLabel.setVisible(true);
            this.numberDimensionsTextField.setVisible(true);
            this.numberDimensionsTextField.setText(Integer.toString(dim));
        } else {
            this.numberDimensionsLabel.setVisible(false);
            this.numberDimensionsTextField.setVisible(false);
        }
    }

    public void setObjects(int objects) {
        if (objects != 0) {
            this.numberObjectsLabel.setVisible(true);
            this.numberObjectsTextField.setVisible(true);
            this.numberObjectsTextField.setText(Integer.toString(objects));
        } else {
            this.numberObjectsLabel.setVisible(false);
            this.numberObjectsTextField.setVisible(false);
        }
    }

    public void setVirtualObjects(int virtualObjects) {
        if (virtualObjects != 0) {
            this.numberVirtualObjectsLabel.setVisible(true);
            this.numberVirtualObjectsTextField.setVisible(true);
            this.numberVirtualObjectsTextField.setText(Integer.toString(virtualObjects));
        } else {
            this.numberVirtualObjectsLabel.setVisible(false);
            this.numberVirtualObjectsTextField.setVisible(false);
        }
    }

    public void setDissType(String diss) {
        if (!diss.isEmpty()) {
            this.distanceTypeLabel.setVisible(true);
            this.distanceTypeTextField.setVisible(true);
            this.distanceTypeTextField.setText(diss);
        } else {
            this.distanceTypeLabel.setVisible(false);
            this.distanceTypeTextField.setVisible(false);
        }
    }

    public void setClassMatchingPanel(String scalarName, int total, int numMatchingObjects, int numNonMatchingObjects, int numNonCorrespondingObjects, TreeMap<Float, HashMap<Float, Integer>> confuseData) {
        if (this.matchs == null) {
            this.matchs = new HashMap();
        }
        ClassMatchData c = null;
        if (!this.matchs.containsKey(scalarName)) {
            this.matchs.put(scalarName, new ClassMatchData(numMatchingObjects, numNonMatchingObjects, numNonCorrespondingObjects, confuseData));
            c = this.matchs.get(scalarName);
        } else {
            c = this.matchs.get(scalarName);
            c.numMatching = numMatchingObjects;
            c.numNonMatching = numNonMatchingObjects;
            c.numNonCorresponding = numNonCorrespondingObjects;
            c.confuseData = confuseData;
        }
        if (c != null) {
            this.updateReportData(c);
        }
    }

    public void updateReportData(Scalar sc) {
        ClassMatchData c = this.matchs.get(sc.getName());
        if (c != null) {
            this.updateReportData(c);
        }
    }

    public void updateReportData(ClassMatchData c) {
        int total = c.numMatching + c.numNonMatching + c.numNonCorresponding;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(1);
        if (c.numMatching == 0 && c.numNonMatching == 0 && c.numNonCorresponding == 0) {
            return;
        }
        this.classMatchingPanel.setVisible(true);
        double percent = (double)c.numMatching / (double)total * 100.0;
        this.matchingTextField.setText(Integer.toString(c.numMatching) + " - " + decimalFormat.format(percent) + "%");
        percent = (double)c.numNonMatching / (double)total * 100.0;
        this.nonMatchingTextField.setText(Integer.toString(c.numNonMatching) + " - " + decimalFormat.format(percent) + "%");
        percent = (double)c.numNonCorresponding / (double)total * 100.0;
        this.nonCorrespondingTextField.setText(Integer.toString(c.numNonCorresponding) + " - " + decimalFormat.format(percent) + "%");
        this.confuseData = c.confuseData;
    }

    public void removeScalarData(Scalar scalar) {
        ClassMatchData c = this.matchs.get(scalar.getName());
        if (c != null) {
            this.matchs.remove(scalar.getName());
        }
        this.classMatchingPanel.setVisible(false);
    }

    public void showHideClassMatchPanel(boolean t) {
        this.classMatchingPanel.setVisible(t);
    }

    public void setColorTable(ColorTable ct) {
        this.colortable = ct;
    }

    public void clean() {
        this.distanceTypeLabel.setVisible(false);
        this.distanceTypeTextField.setVisible(false);
        this.distanceTypeTextField.setText("");
        this.numberObjectsLabel.setVisible(false);
        this.numberObjectsTextField.setVisible(false);
        this.numberObjectsTextField.setText("");
        this.numberDimensionsLabel.setVisible(false);
        this.numberDimensionsTextField.setVisible(false);
        this.numberDimensionsTextField.setText("");
    }
}

