/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;

public class SaveSampleDialog
extends JDialog {
    private String matrixFileName;
    private String source;
    private static SaveSampleDialog instance;
    private SimpleTreeModel model;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton cancelButton;
    private JRadioButton centroidsNearestRadioButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel nroSamplesLabel;
    private JTextField nroSamplesTextField;
    private JButton originalMatrixButton;
    private JLabel originalMatrixLabel;
    private JTextField originalMatrixTextField;
    private JRadioButton overallSamplesRadioButton;
    private JButton pointsButton;
    private JTextField pointsTextField;
    protected JButton saveButton;
    private JPanel sourcePanel;
    private JPanel sourcePanel1;
    private JCheckBox useWeightCheckBox;

    public SaveSampleDialog(JFrame parent, SimpleTreeModel model, String source) {
        super(parent);
        this.initComponents();
        this.setModal(true);
        this.model = model;
        this.source = source;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.sourcePanel = new JPanel();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.nroSamplesLabel = new JLabel();
        this.nroSamplesTextField = new JTextField();
        this.useWeightCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.centroidsNearestRadioButton = new JRadioButton();
        this.overallSamplesRadioButton = new JRadioButton();
        this.sourcePanel1 = new JPanel();
        this.originalMatrixTextField = new JTextField();
        this.originalMatrixButton = new JButton();
        this.originalMatrixLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSampleDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.saveButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSampleDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSampleDialog.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.jLabel1.setText("Samples Filename : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.sourcePanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.sourcePanel, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel2.setLayout(new GridBagLayout());
        this.nroSamplesLabel.setText("Number of Samples : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.nroSamplesLabel, gridBagConstraints);
        this.nroSamplesTextField.setHorizontalAlignment(11);
        this.nroSamplesTextField.setText("0");
        this.nroSamplesTextField.setMinimumSize(new Dimension(56, 20));
        this.nroSamplesTextField.setPreferredSize(new Dimension(56, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.nroSamplesTextField, gridBagConstraints);
        this.useWeightCheckBox.setText("Use Edges Weights");
        this.useWeightCheckBox.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.useWeightCheckBox, gridBagConstraints);
        this.buttonGroup1.add(this.centroidsNearestRadioButton);
        this.centroidsNearestRadioButton.setSelected(true);
        this.centroidsNearestRadioButton.setText("Centroid Nearest Samples");
        this.jPanel3.add(this.centroidsNearestRadioButton);
        this.buttonGroup1.add(this.overallSamplesRadioButton);
        this.overallSamplesRadioButton.setText("Overall Cluster Samples");
        this.jPanel3.add(this.overallSamplesRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.sourcePanel1.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel1.setLayout(new GridBagLayout());
        this.originalMatrixTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.originalMatrixTextField, gridBagConstraints);
        this.originalMatrixButton.setText("Search...");
        this.originalMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSampleDialog.this.originalMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.originalMatrixButton, gridBagConstraints);
        this.originalMatrixLabel.setText("Source File : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.sourcePanel1.add((Component)this.originalMatrixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.sourcePanel1, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.matrixFileName = this.pointsTextField.getText().trim();
        AbstractMatrix originalMatrix = null;
        String typeFile = "";
        try {
            originalMatrix = MatrixFactory.getInstance(this.originalMatrixTextField.getText());
            BufferedReader dataFile = new BufferedReader(new FileReader(new File(this.originalMatrixTextField.getText())));
            typeFile = dataFile.readLine();
            if (typeFile != null && typeFile.length() >= 2) {
                typeFile = typeFile.substring(0, 1);
            }
            dataFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SaveSampleDialog.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Error on loading original Matrix");
        }
        if (originalMatrix == null) {
            JOptionPane.showMessageDialog(this, "Error on loading original Matrix");
            return;
        }
        if (this.matrixFileName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "A sample output filename must be informed!");
            return;
        }
        if (this.nroSamplesTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "A number of samples must be informed!");
            return;
        }
        DistanceMatrix layoutDmat = this.createDistanceMatrix(this.model, this.useWeightCheckBox.isSelected());
        HashMap<Float, ArrayList<Integer>> classes = new HashMap<Float, ArrayList<Integer>>();
        Scalar scalar = this.model.getSelectedScalar();
        if (scalar == null) {
            return;
        }
        for (int i = 0; i < this.model.getValidInstances().size(); ++i) {
            SimpleTreeInstance ti = (SimpleTreeInstance)this.model.getValidInstances().get(i);
            if (!classes.containsKey(Float.valueOf(ti.getScalarValue(scalar)))) {
                classes.put(Float.valueOf(ti.getScalarValue(scalar)), new ArrayList());
            }
            classes.get(Float.valueOf(ti.getScalarValue(scalar))).add(ti.getId());
        }
        HashMap<Float, Integer> medoids = this.getLabelsMedoids(classes, layoutDmat);
        ArrayList[] nn = this.getNeighbors(medoids, classes, layoutDmat);
        AbstractMatrix retSamples = null;
        if (typeFile.equalsIgnoreCase("D")) {
            retSamples = new DenseMatrix();
        } else if (typeFile.equalsIgnoreCase("S")) {
            retSamples = new SparseMatrix();
        }
        retSamples.setAttributes(originalMatrix.getAttributes());
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < nn.length; ++i) {
            for (int j = 0; j < nn[i].size(); ++j) {
                int index = originalMatrix.getIds().indexOf(((Pair)nn[i].get((int)j)).index);
                if (index == -1) continue;
                AbstractVector row = originalMatrix.getRow(index);
                if (row != null) {
                    retSamples.addRow(row);
                }
                labels.add(originalMatrix.getLabels().get(index));
            }
        }
        retSamples.setLabels(labels);
        try {
            retSamples.save(this.matrixFileName);
            JOptionPane.showMessageDialog(this, "Samples Matrix saved!");
        }
        catch (IOException ex) {
            Logger.getLogger(SaveSampleDialog.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Error on saving samples matrix!");
        }
    }

    private ArrayList[] getNeighbors(HashMap<Float, Integer> medoids, HashMap<Float, ArrayList<Integer>> classes, DistanceMatrix layoutDmat) {
        ArrayList[] ret = new ArrayList[medoids.size()];
        int numNeighbors = Integer.parseInt(this.nroSamplesTextField.getText()) / classes.size();
        Iterator<Map.Entry<Float, ArrayList<Integer>>> it = classes.entrySet().iterator();
        int k = 0;
        while (it.hasNext()) {
            Map.Entry<Float, ArrayList<Integer>> e = it.next();
            ArrayList<Integer> membersCluster = classes.get(e.getKey());
            ret[k] = new ArrayList();
            for (int i = 0; i < membersCluster.size(); ++i) {
                int index1 = layoutDmat.getIds().indexOf(medoids.get(e.getKey()));
                int index2 = layoutDmat.getIds().indexOf(membersCluster.get(i));
                if (index1 == -1) continue;
                this.insertPair(new Pair(membersCluster.get(i), layoutDmat.getDistance(index1, index2)), ret[k]);
                if (ret[k].size() <= numNeighbors) continue;
                if (this.centroidsNearestRadioButton.isSelected()) {
                    ret[k].remove(ret[k].size() - 1);
                    continue;
                }
                ret[k].remove(ret[k].size() / 2);
            }
            ++k;
        }
        return ret;
    }

    private void insertPair(Pair p, ArrayList<Pair> list) {
        int index = 0;
        if (list == null) {
            list = new ArrayList();
        }
        while (index < list.size() && p.value > list.get((int)index).value) {
            ++index;
        }
        if (index < list.size()) {
            list.add(index, p);
        } else {
            list.add(p);
        }
    }

    private HashMap<Float, Integer> getLabelsMedoids(HashMap<Float, ArrayList<Integer>> classes, DistanceMatrix layoutDmat) {
        HashMap<Float, Integer> medoids = new HashMap<Float, Integer>();
        for (Map.Entry<Float, ArrayList<Integer>> e : classes.entrySet()) {
            int medoid = this.getMedoid(e.getValue(), layoutDmat);
            medoids.put(e.getKey(), medoid);
        }
        return medoids;
    }

    private int getMedoid(ArrayList<Integer> points, DistanceMatrix layoutDmat) {
        float menor = Float.MAX_VALUE;
        int idMenor = -1;
        float somadist = 0.0f;
        for (int i = 0; i < points.size(); ++i) {
            somadist = 0.0f;
            for (int j = 0; j < points.size(); ++j) {
                int index1 = layoutDmat.getIds().indexOf(points.get(i));
                int index2 = layoutDmat.getIds().indexOf(points.get(j));
                somadist += layoutDmat.getDistance(index1, index2);
            }
            if (!((somadist /= (float)points.size()) < menor)) continue;
            menor = somadist;
            idMenor = points.get(i);
        }
        return idMenor;
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        String directory = "";
        String filename = "";
        int result = SaveDialog.showSaveDialog(new DATAFilter(), this, directory, filename);
        if (result == 0) {
            this.pointsTextField.setText(SaveDialog.getFilename());
        }
    }

    private void originalMatrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.originalMatrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SaveSampleDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SaveSampleDialog getInstance(JFrame parent, SimpleTreeModel model, String source) {
        if (instance == null || instance.getParent() != parent) {
            instance = new SaveSampleDialog(parent, model, source);
        }
        return instance;
    }

    public void display() {
        this.matrixFileName = "";
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private DistanceMatrix createDistanceMatrix(SimpleTreeModel model, boolean useWeights) {
        int k;
        DistanceMatrix dm = new DistanceMatrix();
        float[][] dmat = new float[model.getInstances().size()][model.getInstances().size()];
        for (int i = 0; i < dmat.length; ++i) {
            for (int j = 0; j < dmat[i].length; ++j) {
                dmat[i][j] = i == j ? 0.0f : Float.MAX_VALUE;
            }
        }
        ArrayList<Edge> edges = null;
        if (model.getSelectedConnectivity() != null) {
            edges = model.getSelectedConnectivity().getEdges();
        } else if (model.getConnectivities() != null && model.getConnectivities().size() > 1) {
            edges = model.getConnectivities().get(1).getEdges();
        }
        if (edges == null) {
            return null;
        }
        for (int k2 = 0; k2 < edges.size(); ++k2) {
            Edge ed = edges.get(k2);
            int x = model.getInstances().indexOf(model.getInstanceById(ed.getSource()));
            int y = model.getInstances().indexOf(model.getInstanceById(ed.getTarget()));
            if (useWeights) {
                float f = ed.getWeight();
                dmat[y][x] = f;
                dmat[x][y] = f;
                continue;
            }
            dmat[y][x] = 1.0f;
            dmat[x][y] = 1.0f;
        }
        int n = dmat.length;
        for (k = 0; k < n; ++k) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    float dd = dmat[i][k] + dmat[k][j];
                    if (!(dmat[i][j] > dd)) continue;
                    dmat[i][j] = dd;
                }
            }
        }
        k = -1;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList ndmat = new ArrayList();
        for (int i = 0; i < dmat.length; ++i) {
            if (!((SimpleTreeInstance)model.getInstances().get(i)).isValid()) continue;
            ids.add(model.getInstances().get(i).getId());
            ++k;
            ndmat.add(new ArrayList());
            for (int j = 0; j < dmat[i].length; ++j) {
                if (!((SimpleTreeInstance)model.getInstances().get(j)).isValid()) continue;
                ((ArrayList)ndmat.get(k)).add(Float.valueOf(dmat[i][j]));
            }
        }
        dm.setElementCount(ndmat.size());
        float maxDistance = Float.NEGATIVE_INFINITY;
        float minDistance = Float.POSITIVE_INFINITY;
        float[][] distmat = new float[ndmat.size() - 1][];
        for (int i = 0; i < ndmat.size() - 1; ++i) {
            distmat[i] = new float[i + 1];
            for (int j = 0; j < distmat[i].length; ++j) {
                float distance = ((Float)((ArrayList)ndmat.get(i + 1)).get(j)).floatValue();
                if (distance < minDistance) {
                    minDistance = distance;
                }
                if (distance > maxDistance) {
                    maxDistance = distance;
                }
                if (i + 1 == j) continue;
                if (i + 1 < j) {
                    distmat[j - 1][i + 1] = distance;
                    continue;
                }
                distmat[i + 1 - 1][j] = distance;
            }
        }
        dm.setMinDistance(minDistance);
        dm.setMaxDistance(maxDistance);
        dm.setDistmatrix(distmat);
        Scalar scalar = model.getSelectedScalar();
        if (scalar == null) {
            return null;
        }
        float[] classdata = new float[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            SimpleTreeInstance gi = model.getInstanceById((Integer)ids.get(i));
            if (gi == null) continue;
            classdata[i] = gi.getScalarValue(scalar);
        }
        dm.setClassData(classdata);
        dm.setIds(ids);
        return dm;
    }
}

