/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.MultiscaleParams;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.multiscale.ClusterIO;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.layout.radial.RadialLayoutComp;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.LabelContent;
import simpletree.technique.msnj.MultiScaleNJ;
import simpletree.technique.msnj.MultiScaleNJConnectionComp;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.SimpleTreeFrameComp;
import simpletree.view.selection.AbstractSelection;

public class TreeMultiscaleLocalExpandSelection
extends AbstractSelection {
    private final SimpleTreeFrame frame;
    private ExpansionType expansionType = ExpansionType.LOCAL;

    public TreeMultiscaleLocalExpandSelection(ModelViewer viewer) {
        super(viewer);
        this.frame = (SimpleTreeFrame)viewer;
    }

    public ExpansionType getExpansionType() {
        return this.expansionType;
    }

    public void setExpansionType(ExpansionType expansionType) {
        this.expansionType = expansionType;
    }

    private SimpleTree getNodeTree(ClusterSimpleTreeInstance clusterInstance, SimpleTreeModel treeModel) throws IOException {
        TreeCluster treeCluster = clusterInstance.getTreeCluster();
        if (treeCluster != null) {
            String newickTree = treeCluster.getNewick();
            if ((newickTree == null || newickTree.isEmpty()) && treeModel.getSupertreeFile() != null) {
                treeCluster = treeModel.getSupertreeFile().Cluster.load(clusterInstance.getId());
                clusterInstance.setTreeCluster(treeCluster);
            }
            SimpleTree nodeTree = new SimpleTree(treeCluster.getNewick());
            if (treeModel.getSupertreeFile() != null) {
                SimpleTreeUtil.convertToSuperTree(nodeTree, treeCluster, treeModel.getSupertreeFile());
            } else {
                SimpleTreeUtil.convertToSuperTree(nodeTree, treeCluster, 1, 2, this.frame.treeScalars);
            }
            nodeTree.generateEdges();
            SupertreeFile stFile = treeModel.getSupertreeFile();
            LabelContent labelContent = new LabelContent();
            HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
            for (ContentSimpleTree treeNode : nodeTree.getNodes()) {
                if (!treeNode.isValid()) continue;
                if (treeNode instanceof ClusterContentSimpleTree) {
                    List<Integer> medoids = ((ClusterContentSimpleTree)treeNode).getTreeCluster().getMedoidList();
                    int firstMedoidId = medoids.get(0);
                    if (stFile != null) {
                        treeNode.setKlass(stFile.Scalar.getById(firstMedoidId));
                    } else if (this.frame.treeScalars != null && !this.frame.treeScalars.getValues().isEmpty()) {
                        treeNode.setKlass(this.frame.treeScalars.get(firstMedoidId));
                    } else {
                        treeNode.setKlass(0.0f);
                    }
                    if (stFile != null && stFile.Label.hasLabels()) {
                        labelMap.put(treeNode.getId(), stFile.Label.getById(firstMedoidId));
                        for (Integer medoidId : medoids) {
                            labelMap.put(medoidId, stFile.Label.getById(medoidId));
                        }
                        continue;
                    }
                    if (this.frame.treeLabels == null || this.frame.treeLabels.getLabels().isEmpty()) continue;
                    labelMap.put(treeNode.getId(), this.frame.treeLabels.get(firstMedoidId));
                    for (Integer medoidId : medoids) {
                        labelMap.put(medoidId, this.frame.treeLabels.get(medoidId));
                    }
                    continue;
                }
                if (stFile != null) {
                    treeNode.setKlass(stFile.Scalar.getById(treeNode.getId()));
                    if (!stFile.Label.hasLabels()) continue;
                    labelMap.put(treeNode.getId(), stFile.Label.getById(treeNode.getId()));
                    continue;
                }
                if (this.frame.treeScalars != null && !this.frame.treeScalars.getValues().isEmpty()) {
                    treeNode.setKlass(this.frame.treeScalars.get(treeNode.getId()));
                }
                if (this.frame.treeLabels == null || this.frame.treeLabels.getLabels().isEmpty()) continue;
                labelMap.put(treeNode.getId(), this.frame.treeLabels.get(treeNode.getId()));
            }
            labelContent.setMap(labelMap);
            nodeTree.setLabelContent(labelContent);
            return nodeTree;
        }
        int maxId = Integer.MIN_VALUE;
        for (AbstractInstance instance : this.frame.getModel().getInstances()) {
            if (instance.getId() <= maxId) continue;
            maxId = instance.getId();
        }
        Cluster nodeCluster = clusterInstance.getCluster();
        if (nodeCluster.getSubClusterList().isEmpty() && !nodeCluster.getItemList().isEmpty()) {
            MultiscaleParams msParams = treeModel.getMultiscaleParams();
            msParams.setMaxId(maxId + 1);
            MultiScaleNJ msNJ = new MultiScaleNJ(msParams.isPromotion(), msParams.getType(), msParams.getDissType(), msParams.getMaxId());
            SimpleTree nodeTree = msNJ.execute(nodeCluster, this.frame.getMatrix(), false, msParams);
            nodeTree.setMultiScaleParams(msParams);
            return nodeTree;
        }
        if (!nodeCluster.getSubClusterList().isEmpty() && nodeCluster.getItemList().isEmpty()) {
            List<Cluster> subClusterList;
            HashMap<Integer, Long> clusterMap = this.frame.getClusterData().getMap();
            if (clusterMap != null && !clusterMap.isEmpty()) {
                subClusterList = new ArrayList<Cluster>();
                String clusterFilePath = this.frame.getClusterData().getFilename();
                for (Cluster subCluster : nodeCluster.getSubClusterList()) {
                    long subClusterPosition = (Long)clusterMap.get(subCluster.getId());
                    Cluster newSubCluster = ClusterIO.readBinaryCluster(clusterFilePath, subClusterPosition, true);
                    subClusterList.add(newSubCluster);
                }
            } else {
                subClusterList = nodeCluster.getSubClusterList();
            }
            MultiScaleNJConnectionComp msComp = new MultiScaleNJConnectionComp();
            msComp.input(this.frame.getMatrix(), new MultiscaleData(this.frame.getClusterData().getMap(), subClusterList));
            msComp.setMaxId(maxId + 1);
            msComp.setCreateSingleRoot(true);
            msComp.execute();
            SimpleTree nodeTree = msComp.output();
            treeModel.getMultiscaleParams().setMaxId(maxId + 1);
            return nodeTree;
        }
        if (this.frame.getClusterData() == null) {
            JOptionPane.showMessageDialog(this.frame, "You must first link a ClusterDataset to this Frame", "SubTree build fail", 0);
            return null;
        }
        ArrayList<Cluster> subClusterList = new ArrayList();
        HashMap<Integer, Long> clusterMap = this.frame.getClusterData().getMap();
        if (clusterMap == null || clusterMap.isEmpty()) {
            subClusterList = nodeCluster.getSubClusterList();
        } else {
            String clusterFilePath = this.frame.getClusterData().getFilename();
            for (Cluster subCluster : nodeCluster.getSubClusterList()) {
                long subClusterPosition = clusterMap.get(subCluster.getId());
                Cluster newSubCluster = ClusterIO.readBinaryCluster(clusterFilePath, subClusterPosition, true);
                subClusterList.add(newSubCluster);
            }
        }
        MultiScaleNJConnectionComp msComp = new MultiScaleNJConnectionComp();
        msComp.input(this.frame.getMatrix(), new MultiscaleData(this.frame.getClusterData().getMap(), subClusterList));
        msComp.setMaxId(maxId + 1);
        msComp.setCreateSingleRoot(true);
        msComp.execute();
        SimpleTree nodeTree = msComp.output();
        treeModel.getMultiscaleParams().setMaxId(maxId + 1);
        return nodeTree;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst == null || selinst.size() != 1) {
            return;
        }
        if (!(selinst.get(0) instanceof ClusterSimpleTreeInstance)) {
            return;
        }
        long initTime = System.currentTimeMillis();
        ClusterSimpleTreeInstance instance = (ClusterSimpleTreeInstance)selinst.get(0);
        try {
            SimpleTreeModel treeModel = (SimpleTreeModel)this.frame.getModel();
            SimpleTree nodeTree = this.getNodeTree(instance, treeModel);
            if (nodeTree == null) {
                return;
            }
            SimpleTreeModelComp stc = new SimpleTreeModelComp();
            stc.input(nodeTree);
            stc.execute();
            SimpleTreeModel subModel = stc.output();
            subModel.setMatrix(this.frame.getMatrix());
            if (this.getExpansionType() == ExpansionType.LOCAL) {
                this.localTreeExpansion(subModel, treeModel, instance);
            } else if (this.getExpansionType() == ExpansionType.EXTERNAL) {
                this.externalTreeExpansion(subModel, treeModel, instance);
            }
            this.frame.setShowOutline(false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error on opening cluster tree");
        }
        long endTime = System.currentTimeMillis();
        long diffTime = endTime - initTime;
        System.out.printf("Total time expanding node #%d -> %f seconds.\n", instance.getId(), Float.valueOf((float)diffTime / 1000.0f));
    }

    private void localTreeExpansion(SimpleTreeModel newModel, SimpleTreeModel intoModel, SimpleTreeInstance intoInstance) {
        intoModel.appendTree(newModel, intoInstance.getId(), false);
        LabelContent labels = (LabelContent)intoModel.getContent(AbstractContent.Type.LABEL);
        LabelContent newLabels = (LabelContent)newModel.getContent(AbstractContent.Type.LABEL);
        if (newLabels != null && labels != null) {
            labels.getMap().putAll(newLabels.getMap());
        }
        this.frame.clearVoronoi();
        this.frame.setModel(intoModel);
        this.frame.updateScalars(newModel.getSelectedScalar());
        intoModel.setChanged();
        intoModel.notifyObservers();
    }

    private void externalTreeExpansion(SimpleTreeModel newModel, SimpleTreeModel parentModel, ClusterSimpleTreeInstance instance) throws IOException {
        RadialLayoutComp layoutComp = new RadialLayoutComp();
        layoutComp.input(newModel);
        layoutComp.execute();
        newModel.setScalars(parentModel.getScalars());
        newModel.setColortable(parentModel.getColorTable());
        newModel.setCorpus(parentModel.getCorpus());
        newModel.setMultiScaleLevel(parentModel.getMultiScaleLevel() + 1);
        RadialLayoutComp rc = new RadialLayoutComp();
        rc.input(newModel);
        rc.execute();
        SimpleTreeFrameComp stcf = new SimpleTreeFrameComp();
        stcf.input(rc.output());
        stcf.input(this.frame.getMatrix());
        stcf.input(this.frame.getClusterData());
        stcf.setParentFrame(this.frame);
        stcf.setParentClusterId(instance.getId());
        stcf.execute();
        this.frame.setSubFrameVariables(stcf.getCurrentFrame());
        this.frame.changeStatus("Number of Instances in Selection: " + newModel.getInstances().size());
    }

    @Override
    public ImageIcon getIcon() {
        URL ic = this.getClass().getResource("/resources/ExpandLocal16.png");
        if (ic == null) {
            ic = this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif");
        }
        return new ImageIcon(ic);
    }

    @Override
    public String toString() {
        return "Expand Supernode";
    }

    public static enum ExpansionType {
        LOCAL,
        EXTERNAL;

    }
}

