/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.view.ModelViewer;
import simpletree.view.interaction.TreeAbstractSelection;

public class TreeRadiusSelection
extends TreeAbstractSelection {
    private double distance = 50.0;

    public TreeRadiusSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            if (selinst.size() == 1) {
                selinst = this.selectInRadius((SimpleTreeInstance)selinst.get(0));
            }
            this.viewer.getModel().setSelectedInstances(selinst);
            for (int i = 0; i < this.viewer.getCoordinators().size(); ++i) {
                this.viewer.getCoordinators().get(i).coordinate(selinst, null);
            }
            this.viewer.getModel().notifyObservers();
        }
    }

    private ArrayList<AbstractInstance> selectInRadius(AbstractInstance instance) {
        ArrayList<AbstractInstance> toSelect = new ArrayList<AbstractInstance>();
        SimpleTreeModel model = (SimpleTreeModel)this.viewer.getModel();
        SimpleTreeInstance treeInst = model.getInstanceById(instance.getId());
        for (AbstractInstance currentInstance : model.getInstances()) {
            SimpleTreeInstance currentTreeInst = (SimpleTreeInstance)currentInstance;
            double currentDist = Math.sqrt(Math.pow(treeInst.getX() - currentTreeInst.getX(), 2.0) + Math.pow(treeInst.getY() - currentTreeInst.getY(), 2.0));
            if (!(currentDist < this.distance)) continue;
            toSelect.add(currentInstance);
        }
        return toSelect;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif"));
    }

    @Override
    public String toString() {
        return "Euclidian Radius Select";
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }
}

