/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.ImageContent;
import simpletree.model.content.LabelContent;
import simpletree.technique.packagenj.PackageNJ;
import simpletree.technique.packagenj.PackageNJConnectionComp;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.corpus.folder.FolderCorpus;
import simpletree.textprocessing.processing.view.TextOpenDialog;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.Util;
import simpletree.util.filter.ImageFilter;
import simpletree.util.filter.ZIPFilter;
import simpletree.view.ModelViewer;
import simpletree.view.NewMultipleFileView;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.forms.SimpleTreeMultipleImageView;
import simpletree.view.interaction.TreeAbstractSelection;

public class TreeViewContentSelection
extends TreeAbstractSelection {
    public TreeViewContentSelection(ModelViewer viewer) {
        super(viewer);
    }

    public ArrayList<AbstractInstance> excludeVirtualNodes(ArrayList<AbstractInstance> instances) {
        ArrayList<AbstractInstance> result = new ArrayList<AbstractInstance>();
        result.addAll(instances);
        for (int i = 0; i < result.size(); ++i) {
            SimpleTreeInstance ins = (SimpleTreeInstance)result.get(i);
            if (ins.isValid()) continue;
            result.remove(ins);
            --i;
        }
        return result;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        TreeCluster treeCluster;
        Cluster cluster;
        ArrayList<AbstractInstance> instances;
        SimpleTreeModel treeModel = (SimpleTreeModel)this.viewer.getModel();
        if (treeModel == null || selinst == null || selinst.isEmpty()) {
            return;
        }
        LabelContent labelContent = (LabelContent)this.viewer.getModel().getContent(AbstractContent.Type.LABEL);
        SupertreeFile stFile = treeModel.getSupertreeFile();
        boolean hasLabels = false;
        if (stFile != null) {
            hasLabels = stFile.Label.hasLabels();
        }
        if (labelContent == null && !hasLabels) {
            Logger.getLogger(TreeViewContentSelection.class.getName()).log(Level.SEVERE, "No labels found! This projection does not contains associated data.");
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No labels found! This projection does not contains associated data", "Error", 0, null);
            return;
        }
        if (selinst.size() == 1) {
            instances = TreeViewContentSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            instances = this.excludeVirtualNodes(instances);
        } else {
            instances = this.excludeVirtualNodes(selinst);
        }
        int instanceId = instances.get(0) instanceof ClusterSimpleTreeInstance ? ((cluster = ((ClusterSimpleTreeInstance)instances.get(0)).getCluster()) != null ? (!cluster.getMedoidList().isEmpty() ? cluster.getMedoidList().get(0).intValue() : cluster.getItemList().get(0).intValue()) : (!(treeCluster = ((ClusterSimpleTreeInstance)instances.get(0)).getTreeCluster()).getMedoidList().isEmpty() ? treeCluster.getMedoidList().get(0).intValue() : treeCluster.getItemList().get(0).intValue())) : instances.get(0).getId();
        boolean isText = false;
        if (labelContent != null) {
            isText = labelContent.get(instanceId).contains(".txt");
        }
        if (stFile != null) {
            try {
                isText = stFile.Label.getById(0).contains(".txt");
            }
            catch (IOException ex) {
                Logger.getLogger(TreeViewContentSelection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (isText) {
            this.viewTextContent(instances, treeModel);
        } else {
            this.viewImageContent(instances, treeModel);
        }
        this.viewer.getModel().notifyObservers();
    }

    private List<AbstractInstance> getClusterMedoids(ClusterSimpleTreeInstance instance) {
        SimpleTreeFrame view = (SimpleTreeFrame)this.viewer;
        SimpleTreeModel treeModel = (SimpleTreeModel)this.viewer.getModel();
        ArrayList<AbstractInstance> medoidInstanceList = new ArrayList<AbstractInstance>();
        try {
            Cluster cluster = instance.getCluster();
            AbstractMatrix modelMatrix = view.getMatrix();
            AbstractMatrix medoidMatrix = MatrixFactory.getInstance(modelMatrix.getClass());
            for (Integer instanceIndex : cluster.getMedoidList()) {
                AbstractVector abstractVector = modelMatrix.getRow(instanceIndex);
                medoidMatrix.addRow(abstractVector);
            }
            PackageNJConnectionComp njc = new PackageNJConnectionComp();
            njc.input(medoidMatrix);
            njc.setNjAlgorithmType(PackageNJ.NJAlgorithmType.RAPID);
            njc.setPnj(true);
            njc.setCreateSingleRoot(true);
            njc.execute();
            SimpleTree clusterTree = njc.output();
            SimpleTreeModelComp modelComp = new SimpleTreeModelComp();
            modelComp.input(clusterTree);
            modelComp.execute();
            SimpleTreeModel newModel = modelComp.output();
            HashMap<Integer, Float> classMap = newModel.getClassMap();
            if (classMap != null && !classMap.isEmpty()) {
                for (AbstractInstance ab : newModel.getInstances()) {
                    SimpleTreeInstance sti = (SimpleTreeInstance)ab;
                    int instanceId = Integer.MIN_VALUE;
                    if (sti instanceof ClusterSimpleTreeInstance) {
                        instanceId = ((ClusterSimpleTreeInstance)sti).getMedoidId();
                    } else if (sti instanceof SimpleTreeInstance) {
                        instanceId = sti.getId();
                    }
                    if (!classMap.containsKey(instanceId)) continue;
                    sti.setScalarValue(newModel.getScalarByName("cdata"), classMap.get(instanceId).floatValue());
                }
            }
            newModel.setColortable(treeModel.getColorTable());
            newModel.setSelectedScalar(treeModel.getSelectedScalar());
            for (AbstractInstance simpleInstance : newModel.getInstances()) {
                if (!((SimpleTreeInstance)simpleInstance).isValid()) continue;
                medoidInstanceList.add(simpleInstance);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TreeViewContentSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return medoidInstanceList;
    }

    private void viewTextContent(ArrayList<AbstractInstance> instances, SimpleTreeModel treeModel) {
        Corpus corpus = treeModel.getCorpus();
        try {
            if (corpus == null) {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                corpus = TextOpenDialog.openCorpus(spm, new ZIPFilter(), this.viewer.getContainer());
                if (corpus == null) {
                    treeModel.notifyObservers();
                    return;
                }
                if (corpus instanceof FolderCorpus) {
                    ((FolderCorpus)corpus).setLabels((LabelContent)treeModel.getContent(AbstractContent.Type.LABEL));
                }
                treeModel.setCorpus(corpus);
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList<Color> colors = new ArrayList<Color>();
            for (int i = 0; i < instances.size(); ++i) {
                AbstractInstance inst = instances.get(i);
                if (inst instanceof ClusterSimpleTreeInstance) {
                    TreeCluster treeCluster;
                    Cluster cluster = ((ClusterSimpleTreeInstance)inst).getCluster();
                    if (cluster != null) {
                        ArrayList<Integer> newIds = new ArrayList<Integer>();
                        if (!cluster.getMedoidList().isEmpty()) {
                            newIds.addAll(cluster.getMedoidList());
                        } else {
                            newIds.addAll(cluster.getItemList());
                        }
                        LabelContent labels = (LabelContent)treeModel.getContent(AbstractContent.Type.LABEL);
                        float[] cdata = ((SimpleTreeFrame)this.viewer).getMatrix().getClassData();
                        float max = -3.4028235E38f;
                        float min = Float.MAX_VALUE;
                        for (float cdataValue : cdata) {
                            if (cdataValue > max) {
                                max = cdataValue;
                            }
                            if (!(cdataValue < min)) continue;
                            min = cdataValue;
                        }
                        Object object = newIds.iterator();
                        while (object.hasNext()) {
                            int id = (Integer)object.next();
                            if (!(corpus instanceof FolderCorpus)) {
                                String label = labels.get(id);
                                int hashId = Util.convertToInt(label);
                                ids.add(hashId);
                            } else {
                                ids.add(id);
                            }
                            float scalar = cdata[id];
                            float normalizedScalar = (scalar - min) / (max - min);
                            colors.add(treeModel.getColorTable().getColor(normalizedScalar));
                        }
                    }
                    if ((treeCluster = ((ClusterSimpleTreeInstance)inst).getTreeCluster()) == null) continue;
                    SupertreeFile stFile = treeModel.getSupertreeFile();
                    ArrayList<Integer> newIds = new ArrayList<Integer>();
                    if (treeCluster.getMedoidList().size() == 1 && treeCluster.getSize() > 1) {
                        TreeCluster loadedCluster = stFile.Cluster.load(treeCluster.getId());
                        ((ClusterSimpleTreeInstance)inst).setTreeCluster(loadedCluster);
                        treeCluster = loadedCluster;
                        if (treeModel.getContent(AbstractContent.Type.LABEL) != null) {
                            LabelContent labelContent = (LabelContent)treeModel.getContent(AbstractContent.Type.LABEL);
                            Map<Integer, String> labelsMap = labelContent.getMap();
                            List<String> allLabels = stFile.Label.getLabels();
                            for (int medoidId : treeCluster.getMedoidList()) {
                                labelsMap.put(medoidId, allLabels.get(medoidId));
                            }
                            if (corpus instanceof FolderCorpus) {
                                ((FolderCorpus)corpus).setLabels(labelContent);
                            }
                        }
                    }
                    if (!treeCluster.getMedoidList().isEmpty()) {
                        newIds.addAll(treeCluster.getMedoidList());
                    } else {
                        newIds.addAll(treeCluster.getItemList());
                    }
                    Iterator iterator = newIds.iterator();
                    while (iterator.hasNext()) {
                        int newId = (Integer)iterator.next();
                        if (!(corpus instanceof FolderCorpus)) {
                            String label = stFile.Label.getById(newId);
                            int hashId = Util.convertToInt(label);
                            ids.add(hashId);
                        } else {
                            ids.add(newId);
                        }
                        float scalar = stFile.Scalar.getById(newId);
                        float max = stFile.Scalar.getMax();
                        float min = stFile.Scalar.getMin();
                        float normalized = (scalar - min) / (max - min);
                        colors.add(treeModel.getColorTable().getColor(normalized));
                    }
                    continue;
                }
                SupertreeFile stFile = treeModel.getSupertreeFile();
                if (stFile != null && !(corpus instanceof FolderCorpus)) {
                    String label = stFile.Label.getById(inst.getId());
                    ids.add(Util.convertToInt(label));
                } else {
                    ids.add(inst.getId());
                }
                colors.add(((ProjectionInstance)inst).getColor());
            }
            NewMultipleFileView.getInstance((JFrame)this.viewer.getContainer()).display(corpus, ids, colors);
        }
        catch (IOException ex) {
            Logger.getLogger(TreeViewContentSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean loadImageContent(SimpleTreeModel model) {
        AbstractContent imageContent = model.getContent(AbstractContent.Type.IMAGE);
        if (imageContent != null) {
            model.removeContent(imageContent);
        }
        try {
            PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
            int r = OpenDialog.showOpenDialog(spm, new ImageFilter(), this.viewer.getContainer());
            if (r == 0) {
                LabelContent labelContent = (LabelContent)model.getContent(AbstractContent.Type.LABEL);
                SupertreeFile stFile = model.getSupertreeFile();
                if (labelContent == null && stFile != null) {
                    if (stFile.Label.hasLabels()) {
                        labelContent = new LabelContent();
                        List<String> labels = stFile.Label.getLabels();
                        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
                        for (int i = 0; i < labels.size(); ++i) {
                            labelMap.put(i, labels.get(i));
                        }
                        labelContent.setMap(labelMap);
                        model.addContent(labelContent);
                    } else {
                        return false;
                    }
                }
                model.addContent(new ImageContent(labelContent, OpenDialog.getFilename()));
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private void viewImageContent(ArrayList<AbstractInstance> instances, SimpleTreeModel treeModel) {
        ImageContent imageContent = (ImageContent)treeModel.getContent(AbstractContent.Type.IMAGE);
        if (imageContent == null && !this.loadImageContent(treeModel)) {
            return;
        }
        SimpleTreeMultipleImageView imageView = SimpleTreeMultipleImageView.getInstance((JFrame)this.viewer.getContainer());
        imageView.display(instances);
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"));
    }

    @Override
    public String toString() {
        return "View Content";
    }
}

