/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;

public class JoinScalars
extends JDialog {
    private Scalar scalar;
    private ProjectionModel model;
    private ArrayList<Scalar> tojoin = new ArrayList();
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel framePanel;
    private JButton joinButton;

    private JoinScalars(Frame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.framePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.joinButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Join Scalars");
        this.setModal(true);
        this.framePanel.setBorder(BorderFactory.createTitledBorder("Select Scalars"));
        this.framePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.framePanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.joinButton.setText("Join");
        this.joinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinScalars.this.joinButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.joinButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinScalars.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void joinButtonActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.scalar = this.model.addScalar("joined");
            for (AbstractInstance ai : this.model.getInstances()) {
                ProjectionInstance pi = (ProjectionInstance)ai;
                float max = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < this.tojoin.size(); ++i) {
                    max = Math.max(max, pi.getScalarValue(this.tojoin.get(i)));
                }
                pi.setScalarValue(this.scalar, max);
            }
            this.setVisible(false);
        }
    }

    public static JoinScalars getInstance(Frame parent) {
        return new JoinScalars(parent);
    }

    public Scalar display(ProjectionModel model) {
        this.model = model;
        this.scalar = null;
        this.setScalars(model);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.scalar;
    }

    private void setScalars(ProjectionModel model) {
        ArrayList<Scalar> scalars = model.getScalars();
        for (int i = 0; i < scalars.size(); ++i) {
            if (scalars.get(i).getName().equals("...") || scalars.get(i).getName().equals("joined")) continue;
            JCheckBox check = new JCheckBox(scalars.get(i).toString());
            check.addActionListener(new CheckBoxListener(scalars.get(i)));
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.gridx = 0;
            cons.gridy = i;
            this.framePanel.add((Component)check, cons);
        }
        this.pack();
    }

    class CheckBoxListener
    implements ActionListener {
        private Scalar scalar;

        public CheckBoxListener(Scalar scalar) {
            this.scalar = scalar;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBox) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    JoinScalars.this.tojoin.add(this.scalar);
                } else {
                    JoinScalars.this.tojoin.remove(this.scalar);
                }
            }
        }
    }
}

