/*
 * Decompiled with CFR 0.152.
 */
package mdsj;

import java.util.Random;

public class Data {
    public static String format(double[][] matrix) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                sb.append(String.valueOf(matrix[i][j]) + " ");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void squareDoubleCenter(double[][] matrix) {
        Data.squareEntries(matrix);
        Data.doubleCenter(matrix);
    }

    public static void squareEntries(double[][] matrix) {
        int n = matrix[0].length;
        int k = matrix.length;
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                matrix[i][j] = Math.pow(matrix[i][j], 2.0);
                ++j;
            }
            ++i;
        }
    }

    public static void multiply(double[][] matrix, double factor) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                double[] dArray = matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
            ++i;
        }
    }

    public static double distance(double[][] matrix, int i, int j) {
        double result = 0.0;
        int m = 0;
        while (m < matrix.length) {
            result += Math.pow(matrix[m][i] - matrix[m][j], 2.0);
            ++m;
        }
        return Math.sqrt(result);
    }

    public static double[][] distanceMatrix(double[][] matrix) {
        int n = matrix[0].length;
        double[][] result = new double[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result[i][j] = Data.distance(matrix, i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void doubleCenter(double[][] matrix) {
        double avg;
        int n = matrix[0].length;
        int k = matrix.length;
        int j = 0;
        while (j < k) {
            avg = 0.0;
            int i = 0;
            while (i < n) {
                avg += matrix[j][i];
                ++i;
            }
            avg /= (double)n;
            i = 0;
            while (i < n) {
                double[] dArray = matrix[j];
                int n2 = i++;
                dArray[n2] = dArray[n2] - avg;
            }
            ++j;
        }
        int i = 0;
        while (i < n) {
            avg = 0.0;
            int j2 = 0;
            while (j2 < k) {
                avg += matrix[j2][i];
                ++j2;
            }
            avg /= (double)matrix.length;
            j2 = 0;
            while (j2 < k) {
                double[] dArray = matrix[j2];
                int n3 = i;
                dArray[n3] = dArray[n3] - avg;
                ++j2;
            }
            ++i;
        }
    }

    public static double[][] randomPivotMatrix(double[][] matrix, int k) {
        int n = matrix[0].length;
        double[][] result = new double[k][n];
        boolean[] isPivot = new boolean[n];
        int pivot = 0;
        int i = 0;
        while (i < k) {
            while (isPivot[pivot = (int)(Math.random() * (double)n)]) {
            }
            isPivot[pivot] = true;
            int j = 0;
            while (j < n) {
                result[i][j] = Data.distance(matrix, pivot, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] maxminPivotMatrix(double[][] matrix, int k) {
        int n = matrix[0].length;
        double[][] result = new double[k][n];
        int pivot = 0;
        double[] min = new double[n];
        int i = 0;
        while (i < n) {
            min[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                result[i][j] = Data.distance(matrix, pivot, j);
                ++j;
            }
            pivot = 0;
            j = 0;
            while (j < n) {
                min[j] = Math.min(min[j], result[i][j]);
                if (min[j] > min[pivot]) {
                    pivot = j;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void randomize(double[][] matrix) {
        Random random = new Random(1L);
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = 0.5 - random.nextDouble();
                ++j;
            }
            ++i;
        }
    }

    public static double prod(double[] x, double[] y) {
        double result = 0.0;
        int length = Math.min(x.length, y.length);
        int i = 0;
        while (i < length) {
            result += x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static void selfprod(double[][] d, double[][] result) {
        int k = d.length;
        int n = d[0].length;
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j <= i) {
                double sum = 0.0;
                int m = 0;
                while (m < n) {
                    sum += d[i][m] * d[j][m];
                    ++m;
                }
                result[i][j] = sum;
                result[j][i] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static double normalize(double[] x) {
        double norm = Math.sqrt(Data.prod(x, x));
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] / norm;
        }
        return norm;
    }

    public static void scale(double[][] x, double[][] D) {
        int n = x[0].length;
        int d = x.length;
        double xysum = 0.0;
        double dsum = 0.0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < i) {
                double dxy = 0.0;
                int k = 0;
                while (k < d) {
                    dxy += Math.pow(x[k][i] - x[k][j], 2.0);
                    ++k;
                }
                xysum += Math.sqrt(dxy);
                dsum += D[i][j];
                ++j;
            }
            ++i;
        }
        dsum /= xysum;
        i = 0;
        while (i < n) {
            int k = 0;
            while (k < d) {
                double[] dArray = x[k];
                int n2 = i;
                dArray[n2] = dArray[n2] * dsum;
                ++k;
            }
            ++i;
        }
    }

    public static double[][] pivotRows(double[][] matrix, int k) {
        int K = matrix.length;
        if (k >= K) {
            return matrix;
        }
        int n = matrix[0].length;
        System.out.println(String.valueOf(n) + " " + k + " " + K);
        double[][] result = new double[k][n];
        int pivot = 0;
        double[] min = new double[n];
        int i = 0;
        while (i < n) {
            min[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < k) {
            int argmax = 0;
            int j = 0;
            while (j < n) {
                result[i][j] = matrix[i][pivot];
                min[j] = Math.min(min[j], result[i][j]);
                if (min[j] > min[argmax]) {
                    argmax = j;
                }
                ++j;
            }
            pivot = argmax;
            ++i;
        }
        return result;
    }

    public static int[] landmarkIndices(double[][] matrix) {
        int k = matrix.length;
        int n = matrix[0].length;
        int[] result = new int[k];
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                if (matrix[i][j] == 0.0) {
                    result[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] landmarkMatrix(double[][] matrix) {
        int k = matrix.length;
        int n = matrix[0].length;
        double[][] result = new double[k][k];
        int[] index = Data.landmarkIndices(matrix);
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < k) {
                result[i][j] = matrix[i][index[j]];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void normalize(double[][] x) {
        int i = 0;
        while (i < x.length) {
            Data.normalize(x[i]);
            ++i;
        }
    }
}

