/*
 * Decompiled with CFR 0.152.
 */
package mdsj;

import mdsj.Data;

public class StressMinimization {
    private double[][] x;
    private double[][] d;
    private double[][] w;

    public StressMinimization(double[][] d, double[][] x, double[][] w) {
        this.x = x;
        this.d = d;
        this.w = w;
    }

    public StressMinimization(double[][] d, double[][] x) {
        this.x = x;
        this.d = d;
        this.w = StressMinimization.weightMatrix(d, 0.0);
    }

    public double[][] getDissimilarities() {
        return this.d;
    }

    public double[][] getWeights() {
        return this.w;
    }

    public double[][] getPositions() {
        return this.x;
    }

    public void setDissimilarities(double[][] d) {
        this.d = d;
    }

    public void setWeights(double[][] w) {
        this.w = w;
    }

    public void setPositions(double[][] x) {
        this.x = x;
    }

    public String iterate() {
        return this.iterate(1);
    }

    public String iterate(int n) {
        return StressMinimization.majorize(this.x, this.d, this.w, n, 0, 0);
    }

    public String iterate(int iter, int timeout, int threshold) {
        return StressMinimization.majorize(this.x, this.d, this.w, iter, timeout, threshold);
    }

    public double getStress() {
        return StressMinimization.stress(this.d, this.w, this.x);
    }

    public double getNormalizedStress() {
        return StressMinimization.normalizedStress(this.d, this.w, this.x);
    }

    public static double[][] weightMatrix(double[][] D, double exponent) {
        int n = D[0].length;
        int k = D.length;
        double[][] result = new double[k][n];
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                if (D[i][j] > 0.0) {
                    result[i][j] = Math.pow(D[i][j], exponent);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String majorize(double[][] x, double[][] d, double[][] w, int iter, int threshold, int timeout) {
        String report = "";
        int n = x[0].length;
        int k = d.length;
        int dim = x.length;
        int[] index = Data.landmarkIndices(d);
        double[] wSum = new double[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < k) {
                int n2 = i;
                wSum[n2] = wSum[n2] + w[j][i];
                ++j;
            }
            ++i;
        }
        double eps = Math.pow(10.0, -threshold);
        long time = System.nanoTime();
        if (iter == 0) {
            iter = 10000000;
        }
        int c = 0;
        while (c < iter) {
            double change = 0.0;
            double magnitude = 0.0;
            int i2 = 0;
            while (i2 < n) {
                double[] xnew = new double[dim];
                int j = 0;
                while (j < k) {
                    double inv = 0.0;
                    int m = 0;
                    while (m < dim) {
                        inv += Math.pow(x[m][i2] - x[m][index[j]], 2.0);
                        ++m;
                    }
                    if (inv != 0.0) {
                        inv = Math.pow(inv, -0.5);
                    }
                    m = 0;
                    while (m < dim) {
                        int n3 = m;
                        xnew[n3] = xnew[n3] + w[j][i2] * (x[m][index[j]] + d[j][i2] * (x[m][i2] - x[m][index[j]]) * inv);
                        ++m;
                    }
                    ++j;
                }
                if (wSum[i2] != 0.0) {
                    int m = 0;
                    while (m < dim) {
                        change += Math.pow(xnew[m] / wSum[i2] - x[m][i2], 2.0);
                        magnitude += Math.pow(x[m][i2], 2.0);
                        x[m][i2] = xnew[m] / wSum[i2];
                        ++m;
                    }
                }
                ++i2;
            }
            change = Math.sqrt(change / magnitude);
            long timediff = (System.nanoTime() - time) / 1000000L;
            if (timeout > 0 && timediff > (long)timeout) {
                return String.valueOf(c + 1) + " iterations, " + timediff + " milliseconds, " + change + " relative change";
            }
            if (threshold > 0 && change < eps) {
                return String.valueOf(c + 1) + " iterations, " + timediff + " milliseconds, " + change + " relative change";
            }
            if (iter > 0 && c >= iter - 1) {
                report = String.valueOf(c + 1) + " iterations, " + timediff + " milliseconds, " + change + " relative change";
            }
            ++c;
        }
        return report;
    }

    public static void majorize(double[][] x, double[][] d, double[][] w, int iter) {
        int n = x[0].length;
        int dim = x.length;
        double[] wSum = new double[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                int n2 = i;
                wSum[n2] = wSum[n2] + w[i][j];
                ++j;
            }
            ++i;
        }
        int c = 0;
        while (c < iter) {
            int i2 = 0;
            while (i2 < n) {
                double[] xnew = new double[dim];
                int j = 0;
                while (j < n) {
                    double inv = 0.0;
                    int k = 0;
                    while (k < dim) {
                        inv += Math.pow(x[k][i2] - x[k][j], 2.0);
                        ++k;
                    }
                    if (inv != 0.0) {
                        inv = Math.pow(inv, -0.5);
                    }
                    k = 0;
                    while (k < dim) {
                        int n3 = k;
                        xnew[n3] = xnew[n3] + w[i2][j] * (x[k][j] + d[i2][j] * (x[k][i2] - x[k][j]) * inv);
                        ++k;
                    }
                    ++j;
                }
                if (wSum[i2] != 0.0) {
                    int k = 0;
                    while (k < dim) {
                        x[k][i2] = xnew[k] / wSum[i2];
                        ++k;
                    }
                }
                ++i2;
            }
            ++c;
        }
    }

    public static double stress(double[][] d, double[][] w, double[][] x) {
        double result = 0.0;
        int n = x[0].length;
        int k = d.length;
        int dim = x.length;
        int[] index = Data.landmarkIndices(d);
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                double dist = 0.0;
                int m = 0;
                while (m < dim) {
                    dist += Math.pow(x[m][index[i]] - x[m][j], 2.0);
                    ++m;
                }
                result += w[i][j] * Math.pow(d[i][j] - Math.sqrt(dist), 2.0);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double normalizedStress(double[][] d, double[][] w, double[][] x) {
        double result = 0.0;
        int n = x[0].length;
        int k = d.length;
        int dim = x.length;
        int[] index = Data.landmarkIndices(d);
        double sum = 0.0;
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < n) {
                double dist = 0.0;
                int m = 0;
                while (m < dim) {
                    dist += Math.pow(x[m][index[i]] - x[m][j], 2.0);
                    ++m;
                }
                result += w[i][j] * Math.pow(d[i][j] - Math.sqrt(dist), 2.0);
                sum += w[i][j] * Math.pow(d[i][j], 2.0);
                ++j;
            }
            ++i;
        }
        return result / sum;
    }
}

