/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class LagrangeProjection
extends Projection {
    private double hrw;
    private double rw = 1.4;
    private double a1;
    private double phi1;
    private static final double TOL = 1.0E-10;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double xy) {
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) < 1.0E-10) {
            xy.x = 0.0;
            xy.y = lpphi < 0.0 ? -2.0 : 2.0;
        } else {
            double d;
            lpphi = Math.sin(lpphi);
            double v = this.a1 * Math.pow((1.0 + lpphi) / (1.0 - lpphi), this.hrw);
            double c = 0.5 * (v + 1.0 / v) + Math.cos(lplam *= this.rw);
            if (d < 1.0E-10) {
                throw new ProjectionException();
            }
            xy.x = 2.0 * Math.sin(lplam) / c;
            xy.y = (v - 1.0 / v) / c;
        }
        return xy;
    }

    public void setW(double w) {
        this.rw = w;
    }

    public double getW() {
        return this.rw;
    }

    public void initialize() {
        double d;
        super.initialize();
        if (this.rw <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.rw = 1.0 / this.rw;
        this.hrw = 0.5 * this.rw;
        this.phi1 = this.projectionLatitude1;
        this.phi1 = Math.sin(this.phi1);
        if (Math.abs(Math.abs(d) - 1.0) < 1.0E-10) {
            throw new ProjectionException("-22");
        }
        this.a1 = Math.pow((1.0 - this.phi1) / (1.0 + this.phi1), this.hrw);
    }

    public boolean isConformal() {
        return true;
    }

    public boolean hasInverse() {
        return false;
    }

    public String toString() {
        return "Lagrange";
    }
}

