/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.bayes;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.classification.bayes.BayesResult;
import net.sf.javaml.classification.bayes.ClassCounter;
import net.sf.javaml.classification.bayes.Functions;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class AbstractBayesianClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 5632827558415021535L;
    Functions fnc = new Functions();
    protected int numClasses;
    protected int numFeatures;
    protected int numInstances;
    protected boolean laplace;
    protected boolean log;
    protected boolean sparse;
    protected BayesResult trainResult;
    protected Dataset trainingData;
    protected Object[] classes;
    protected HashMap<String, Integer> Classname2IndexCCountermap;
    protected int initialCap;

    public AbstractBayesianClassifier(boolean lap, boolean log, boolean sparse) {
        this.laplace = lap;
        this.log = log;
        this.sparse = sparse;
        this.Classname2IndexCCountermap = new HashMap();
    }

    @Override
    public void buildClassifier(Dataset data) {
        this.trainingData = data;
        this.trainResult = new BayesResult();
        this.numInstances = this.trainingData.size();
        this.numClasses = this.trainingData.classes().size();
        this.classes = new Object[this.numClasses];
        int cnt = 0;
        for (Object e : this.trainingData.classes()) {
            String classname = e.toString();
            this.Classname2IndexCCountermap.put(classname, cnt);
            this.classes[cnt] = classname;
            ++cnt;
        }
        this.trainResult.setClassFreqs(this.calculateClassFreqs(this.trainingData));
        this.trainResult.setClassProbs(this.calculateClassProbs());
        this.trainResult.setFeatureTable(this.conditionalFreq(this.trainingData));
        if (this.sparse) {
            this.trainResult.setFeatureTable(this.updateFT());
        }
        this.initialCap = (int)Math.ceil((double)this.numFeatures / 0.75) + 10;
    }

    private Hashtable<Integer, Hashtable<Double, ClassCounter>> updateFT() {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        for (Integer key : featureName_HT.keySet()) {
            if (featureName_HT.get(key).containsKey(12345.6789)) continue;
            featureName_HT.get(key).put(12345.6789, new ClassCounter(this.classes.length));
            for (int k = 0; k < this.numClasses; ++k) {
                featureName_HT.get(key).get(12345.6789).setCountClass(freq[k] - this.sumOccurencesAllFVsForClass(key, k), k);
                featureName_HT.get(key).get(12345.6789).setClassInstanceIDList(this.sumOccurencesAllFVsForClassInstanceIDs(key, k), k);
            }
        }
        return featureName_HT;
    }

    private Vector<Integer> sumOccurencesAllFVsForClassInstanceIDs(int FN, int c) {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        Vector classInstanceLists = (Vector)this.trainResult.getClassInstanceList(c).clone();
        for (Double key2 : featureName_HT.get(FN).keySet()) {
            if (key2 == 12345.6789) continue;
            Iterator<Integer> itr = featureName_HT.get(FN).get(key2).getClassInstanceIDList(c).iterator();
            while (itr.hasNext()) {
                classInstanceLists.removeElement(itr.next());
            }
        }
        return classInstanceLists;
    }

    private double sumOccurencesAllFVsForClass(int FN, int c) {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        double Sum_score = 0.0;
        for (Double key2 : featureName_HT.get(FN).keySet()) {
            Sum_score += featureName_HT.get(FN).get(key2).getCountClass(c);
        }
        return Sum_score;
    }

    private double[] calculateClassFreqs(Dataset Instances2Train) {
        double[] classFrequencies = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            classFrequencies[i] = 0.0;
        }
        for (Instance inst : Instances2Train) {
            int n = this.Classname2IndexCCountermap.get(inst.classValue());
            classFrequencies[n] = classFrequencies[n] + 1.0;
        }
        return classFrequencies;
    }

    private double[] calculateClassProbs() {
        double[] probs = (double[])this.trainResult.getClassFreqs().clone();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        for (int k = 0; k < this.numClasses; ++k) {
            probs[k] = (freq[k] + 1.0) / (double)(this.numInstances + this.numClasses);
        }
        return probs;
    }

    private Hashtable<Integer, Hashtable<Double, ClassCounter>> conditionalFreq(Dataset Instances2Train) {
        this.trainResult.initInstanceIDtoClassListArray(this.numClasses);
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = new Hashtable<Integer, Hashtable<Double, ClassCounter>>(this.numFeatures);
        int instanceid_count = 1;
        for (Instance inst : Instances2Train) {
            for (Object e : inst.keySet()) {
                int featureName = (Integer)e;
                Double featureValue = inst.value((Integer)e);
                if (!featureName_HT.containsKey(featureName)) {
                    Hashtable<Double, ClassCounter> featureValue_CC = new Hashtable<Double, ClassCounter>();
                    featureValue_CC.put(featureValue, new ClassCounter(this.numClasses));
                    featureName_HT.put(featureName, featureValue_CC);
                } else if (!featureName_HT.get(featureName).containsKey(featureValue)) {
                    featureName_HT.get(featureName).put(featureValue, new ClassCounter(this.classes.length));
                }
                featureName_HT.get(featureName).get(featureValue).setCountClass(featureName_HT.get(featureName).get(featureValue).getCountClass(this.Classname2IndexCCountermap.get(inst.classValue())) + 1.0, this.Classname2IndexCCountermap.get(inst.classValue()));
                featureName_HT.get(featureName).get(featureValue).addInstanceIDtoList(this.Classname2IndexCCountermap.get(inst.classValue()), instanceid_count);
            }
            this.trainResult.addInstanceIDtoClassList(this.Classname2IndexCCountermap.get(inst.classValue()), instanceid_count);
            ++instanceid_count;
        }
        this.numFeatures = featureName_HT.size();
        return featureName_HT;
    }

    protected double getInstValue(int topology_element, Instance inst) {
        if (!inst.containsKey(topology_element)) {
            return 12345.6789;
        }
        return (Double)inst.get(topology_element);
    }

    public HashMap<Object, Double> calcFictionalChances(HashMap<Object, Double> distribution) {
        double smallestBuildingBlock = 100 / distribution.keySet().size();
        LinkedHashMap outS = this.fnc.sortHashMapByValues(distribution, true);
        int index = 1;
        for (Object key : outS.keySet()) {
            distribution.put(key, (double)index * smallestBuildingBlock);
            ++index;
        }
        return distribution;
    }

    protected void coverAbsentFeatures_And_fill_helpMap(Instance inst) {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        for (Object e : inst.keySet()) {
            int featureName = (Integer)e;
            Double featureValue = inst.value((Integer)e);
            if (!featureName_HT.containsKey(featureName) || featureName_HT.get(featureName).containsKey(featureValue)) continue;
            featureName_HT.get(featureName).put(featureValue, new ClassCounter(this.classes.length));
        }
        this.trainResult.setFeatureTable(featureName_HT);
    }

    public boolean getSparse() {
        return this.sparse;
    }

    public Hashtable<Integer, Hashtable<Double, ClassCounter>> getFeatureTable() {
        return this.trainResult.getFeatureTable();
    }

    public Object[] getClassesMap() {
        return this.classes;
    }

    public HashMap<String, Integer> getClassesRevMap() {
        return this.Classname2IndexCCountermap;
    }

    public double[] getClassFreqs() {
        return (double[])this.trainResult.getClassFreqs().clone();
    }
}

