/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.bayes;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

class BayesNet {
    protected HashMap<Integer, Vector<Integer>> parentNodes;
    protected HashMap<Integer, Vector<Integer>> childrenNodes;
    protected HashMap<Integer, Integer> parentcount;
    private int initialcapacity_vector;
    private int initialcapacity_hashmaps;

    BayesNet() {
        this.parentNodes = new HashMap(this.initialcapacity_hashmaps);
        this.childrenNodes = new HashMap(this.initialcapacity_hashmaps);
        this.parentcount = new HashMap(this.initialcapacity_hashmaps);
    }

    void setIC(int icv, int ichm) {
        this.initialcapacity_hashmaps = ichm;
        this.initialcapacity_vector = icv + 1;
    }

    boolean addNode(int feature) {
        if (!this.parentNodes.containsKey(feature)) {
            this.parentNodes.put(feature, new Vector());
            this.parentcount.put(feature, 0);
            this.childrenNodes.put(feature, new Vector());
            return true;
        }
        return false;
    }

    HashMap<Integer, Integer> getparentCountMap() {
        return this.parentcount;
    }

    private void setparentCountMap(HashMap<Integer, Integer> parentCount) {
        this.parentcount = parentCount;
    }

    HashMap<Integer, Vector<Integer>> getParentNodeMap() {
        return this.parentNodes;
    }

    private void setParentNodeMap(HashMap<Integer, Vector<Integer>> nodes) {
        this.parentNodes = nodes;
    }

    private HashMap<Integer, Vector<Integer>> getChildrenNodeMap() {
        return this.childrenNodes;
    }

    private void setChildrenNodeMap(HashMap<Integer, Vector<Integer>> nodes) {
        this.childrenNodes = nodes;
    }

    Set<Integer> getNodes() {
        return this.parentNodes.keySet();
    }

    Vector<Integer> getNodeParents(int feature) {
        return this.parentNodes.get(feature);
    }

    void setNodeParents(int feature, Vector<Integer> v) {
        this.parentNodes.put(feature, v);
    }

    int getparentCount(int feature) {
        return this.parentcount.get(feature);
    }

    void setparentCount(int feature, int cnt) {
        this.parentcount.put(feature, cnt);
    }

    Vector<Integer> getNodeChildren(int feature) {
        return this.childrenNodes.get(feature);
    }

    void setNodeChildren(int feature, Vector<Integer> v) {
        this.childrenNodes.put(feature, v);
    }

    void addParent(int feature, int parent) {
        this.parentNodes.get(feature).add(parent);
        this.parentcount.put(feature, this.parentcount.get(feature) + 1);
        this.childrenNodes.get(parent).add(feature);
    }

    BayesNet cloon() {
        BayesNet BN2 = new BayesNet();
        HashMap<Integer, Vector<Integer>> parentNodesMap = new HashMap<Integer, Vector<Integer>>(this.initialcapacity_hashmaps);
        HashMap<Integer, Vector<Integer>> childrenNodesMap = new HashMap<Integer, Vector<Integer>>(this.initialcapacity_hashmaps);
        HashMap<Integer, Integer> parentcountMap = new HashMap<Integer, Integer>(this.initialcapacity_hashmaps);
        for (int node : this.getNodes()) {
            parentNodesMap.put(node, (Vector)this.getParentNodeMap().get(node).clone());
            parentcountMap.put(node, this.getparentCount(node));
            childrenNodesMap.put(node, (Vector)this.getChildrenNodeMap().get(node).clone());
        }
        BN2.setParentNodeMap(parentNodesMap);
        BN2.setChildrenNodeMap(childrenNodesMap);
        BN2.setparentCountMap(parentcountMap);
        return BN2;
    }
}

